from ui_wrapper import _ui
import app,net,wndMgr,background
import ui,uiCommon,serverInfo,localeInfo

class uiChangeChannel(ui.Window):
	def __init__(self, stream):
		ui.Window.__init__(self)
		self.stream = stream
		
		self.Board = None
		self.btnChildren = []
		self.serverID = None
		self.channels = None
		self.regionID = None
		
		self.__LoadWindow()
		self.CreateGUI()
	
	def __del__(self):
		ui.Window.__del__(self)
		
	def __LoadWindow(self):
		file = open("channel.inf", "r")
		lines = file.readlines()
		file.close()
		
		if len(lines):
			tokens = lines[0].split()
			self.serverID = int(tokens[0])
			selChannelID = int(tokens[1])
			if len(tokens) == 3:
				self.regionID = int(tokens[2])
			else:
				self.regionID = 0
		
		self.channels = serverInfo.REGION_DICT[self.regionID][self.serverID]["channel"]
	
	def CreateGUI(self):
		self.Board = _ui().BoardWithTitleBar(None, 0, 1, 0, 180, 180, localeInfo.CHANGE_CHANNEL, self.Close)
		
		for i in xrange(len(self.channels)):
			btn = _ui().Button(self.Board, self.channels[i + 1]["name"], "", 0, 35 + 30*i, lambda arg = i + 1: self.__ChangeChannel(arg), "d:/ymir work/ui/buton/1.tga", "d:/ymir work/ui/buton/2.tga", "d:/ymir work/ui/buton/3.tga")
			btn.SetDisableVisual("d:/ymir work/ui/buton/3.tga")
			btn.SetWindowHorizontalAlignCenter()
			
			if str(net.GetServerInfo()[-1:]) == str(i + 1):
				btn.Disable()
			self.btnChildren.append(btn)
		
		self.Board.SetSize(180, len(self.channels) * 40)
		self.Board.SetPosition(wndMgr.GetScreenWidth()/2 - 70, wndMgr.GetScreenHeight() / 2 - (len(self.channels) * 35))
		
	def __ChangeChannel(self, ch):
		if str(ch) == str(net.GetServerInfo()[-1:]):
			self.Popup = _ui().Popup(localeInfo.CHANNEL_SAME, None, None)
			return
		
		self.stream.channel = ch
		ip = serverInfo.REGION_DICT[0][1]["channel"][ch]["ip"]
		tcp_port = serverInfo.REGION_DICT[0][1]["channel"][ch]["tcp_port"]
		account_ip = serverInfo.REGION_AUTH_SERVER_DICT[0][1]["ip"]
		account_port = serverInfo.REGION_AUTH_SERVER_DICT[0][1]["port"]
		state = serverInfo.REGION_DICT[0][1]["channel"][ch]["state"]
		slot = self.stream.GetCharacterSlot()
					
		if state == serverInfo.STATE_DICT[3]:
			self.Popup = _ui().Popup(localeInfo.CHANNEL_FULL, None, None)
			return
			
		if self.IsInSpecialMap():
			self.Popup = _ui().Popup(localeInfo.CHANNEL_SPECIAL_MAP, None, None)
			return

		self.stream.SetConnectInfo(ip, tcp_port, account_ip, account_port)
		markKey = self.regionID * 1000 + self.serverID * 10
		markAddrValue=serverInfo.MARKADDR_DICT[markKey]
		net.SetMarkServer(markAddrValue["ip"], markAddrValue["tcp_port"])
		app.SetGuildMarkPath(markAddrValue["mark"])
		app.SetGuildSymbolPath(markAddrValue["symbol_path"])
		self.Close()
		
		file=open("channel.inf", "w")
		file.write("%d %d %d" % (self.serverID, ch, self.regionID))
		file.close()
		net.SetServerInfo(str(net.GetServerInfo()[:-1]) + str(ch))
		net.LogOutGame()
		self.stream.SetLoginInfo(net.ACC_ID, net.ACC_PWD)
		self.stream.Connect()
		
		self.stream.SetCharacterSlot(slot)
		self.stream.isAutoSelect=1
	
	def IsInSpecialMap(self):
		bad_maps = [
			"season1/metin2_map_oxevent", "season2/metin2_map_guild_inside01", "season2/metin2_map_empirewar01",
			"season2/metin2_map_empirewar02", "season2/metin2_map_empirewar03", "metin2_map_empirewar02",
			"metin2_map_dragon_timeattack_01", "metin2_map_dragon_timeattack_02", "metin2_map_dragon_timeattack_03",
			"metin2_map_skipia_dungeon_boss", "metin2_map_skipia_dungeon_boss2", "metin2_map_devilsCatacomb",
			"metin2_map_deviltower1", "metin2_map_t1", "metin2_map_t2", "metin2_map_t3", "metin2_map_t4",
			"metin2_map_t5", "metin2_map_wedding_01", "metin2_map_duel", "metin2_map_dawnmist_dungeon_01", "metin2_map_mt_th_dungeon_01"
		]
		if str(background.GetCurrentMapName()) in bad_maps:
			return True
		return False

	def Show(self):
		self.Board.Show()
	
	def Close(self):
		self.Board.Hide()
		
	def OnPressEscapeKey(self):
		self.Close()
		return True
		
