import ui
import localeInfo
import app
import ime
import uiScriptLocale
import dbg
import wndMgr

class PopupDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__LoadDialog()
		self.acceptEvent = lambda *arg: None

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __LoadDialog(self):
		try:
			PythonScriptLoader = ui.PythonScriptLoader()
			PythonScriptLoader.LoadScriptFile(self, "UIScript/PopupDialog.py")

			self.board = self.GetChild("board")
			self.message = self.GetChild("message")
			self.accceptButton = self.GetChild("accept")
			self.accceptButton.SetEvent(ui.__mem_func__(self.Close))

		except:
			import exception
			exception.Abort("PopupDialog.LoadDialog.BindObject")

	def Open(self):
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.Hide()
		self.acceptEvent()

	def Destroy(self):
		self.Close()
		self.ClearDictionary()

	def SetWidth(self, width):
		height = self.GetHeight()
		self.SetSize(width, height)
		self.board.SetSize(width, height)
		self.SetCenterPosition()
		self.UpdateRect()

	def SetText(self, text):
		self.message.SetText(text)

	def SetAcceptEvent(self, event):
		self.acceptEvent = event

	def SetButtonName(self, name):
		self.accceptButton.SetText(ButtonName)

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

	def OnIMEReturn(self):
		self.Close()
		return TRUE

class InputDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/inputdialog.py")

		getObject = self.GetChild
		self.board = getObject("Board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputSlot = getObject("InputSlot")
		self.inputValue = getObject("InputValue")

	def Open(self):
		self.inputValue.SetFocus()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputSlot = None
		self.inputValue = None
		self.Hide()

	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetNumberMode(self):
		self.inputValue.SetNumberMode()

	def SetSecretMode(self):
		self.inputValue.SetSecret()

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		width = length * 6 + 10
		self.SetBoardWidth(max(width + 50, 160))
		self.SetSlotWidth(width)
		self.inputValue.SetMax(length)

	def SetSlotWidth(self, width):
		self.inputSlot.SetSize(width, self.inputSlot.GetHeight())
		self.inputValue.SetSize(width, self.inputValue.GetHeight())
		if self.IsRTL():
			self.inputValue.SetPosition(self.inputValue.GetWidth(), 0)

	def SetBoardWidth(self, width):
		self.SetSize(max(width + 50, 160), self.GetHeight())
		self.board.SetSize(max(width + 50, 160), self.GetHeight())	
		if self.IsRTL():
			self.board.SetPosition(self.board.GetWidth(), 0)
		self.UpdateRect()

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event

	def GetText(self):
		return self.inputValue.GetText()


class InputDialogShop(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()
		self.type = 0

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/inputdialogshop.py")

		getObject = self.GetChild
		self.board = getObject("Board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputSlot = getObject("InputSlot")
		self.inputValue = getObject("InputValue")
		self.inputType0 = getObject("InputType0")
		self.inputType1 = getObject("InputType1")
		self.inputType2 = getObject("InputType2")
		self.inputType3 = getObject("InputType3")
		
		self.inputType0.SetEvent(self.__ChangeInputType0)
		self.inputType1.SetEvent(self.__ChangeInputType1)
		self.inputType2.SetEvent(self.__ChangeInputType2)
		self.inputType3.SetEvent(self.__ChangeInputType3)
		
		
	def Open(self):
		self.inputValue.SetFocus()
		self.__ChangeInputType0()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()
		

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputSlot = None
		self.inputValue = None
		self.inputType0 = None
		self.inputType1 = None
		self.inputType2 = None
		self.inputType3 = None
		self.type = None
		self.Hide()
		
	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetNumberMode(self):
		self.inputValue.SetNumberMode()

	def SetSecretMode(self):
		self.inputValue.SetSecret()

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		width = length * 6 + 10
		self.SetBoardWidth(max(width + 50, 160))
		self.SetSlotWidth(width)
		self.inputValue.SetMax(length)

	def SetSlotWidth(self, width):
		self.inputSlot.SetSize(width, self.inputSlot.GetHeight())
		self.inputValue.SetSize(width, self.inputValue.GetHeight())
		if self.IsRTL():
			self.inputValue.SetPosition(self.inputValue.GetWidth(), 0)

	def SetBoardWidth(self, width):
		self.SetSize(max(width + 50, 160), self.GetHeight())
		self.board.SetSize(max(width + 50, 160), self.GetHeight())	
		if self.IsRTL():
			self.board.SetPosition(self.board.GetWidth(), 0)
		self.UpdateRect()

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event
		
	def __ChangeInputType0(self):
		self.type = 0
		self.GetChild("InputType0").Down()
		self.GetChild("InputType1").SetUp()
		self.GetChild("InputType2").SetUp()
		self.GetChild("InputType3").SetUp()
	
	def __ChangeInputType1(self):
		self.type = 1
		self.GetChild("InputType0").SetUp()
		self.GetChild("InputType1").Down()
		self.GetChild("InputType2").SetUp()
		self.GetChild("InputType3").SetUp()
		
	def __ChangeInputType2(self):
		self.type = 2
		self.GetChild("InputType0").SetUp()
		self.GetChild("InputType1").SetUp()
		self.GetChild("InputType2").Down()
		self.GetChild("InputType3").SetUp()
		
	def __ChangeInputType3(self):
		self.type = 3
		self.GetChild("InputType0").SetUp()
		self.GetChild("InputType1").SetUp()
		self.GetChild("InputType2").SetUp()
		self.GetChild("InputType3").Down()

	def GetText(self):
		return self.inputValue.GetText()
		
	def GetType(self):
		return int(self.type)
		
class InputDialogWithDescription(InputDialog):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()

	def __del__(self):
		InputDialog.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		if localeInfo.IsARABIC() :
			pyScrLoader.LoadScriptFile(self, uiScriptLocale.LOCALE_UISCRIPT_PATH + "inputdialogwithdescription.py")
		else:
			pyScrLoader.LoadScriptFile(self, "uiscript/inputdialogwithdescription.py")

		try:
			getObject = self.GetChild
			self.board = getObject("Board")
			self.acceptButton = getObject("AcceptButton")
			self.cancelButton = getObject("CancelButton")
			self.inputSlot = getObject("InputSlot")
			self.inputValue = getObject("InputValue")
			self.description = getObject("Description")

		except:
			import exception
			exception.Abort("InputDialogWithDescription.LoadBoardDialog.BindObject")

	def SetDescription(self, text):
		self.description.SetText(text)

class InputDialogWithDescription2(InputDialog):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()

	def __del__(self):
		InputDialog.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/inputdialogwithdescription2.py")

		try:
			getObject = self.GetChild
			self.board = getObject("Board")
			self.acceptButton = getObject("AcceptButton")
			self.cancelButton = getObject("CancelButton")
			self.inputSlot = getObject("InputSlot")
			self.inputValue = getObject("InputValue")
			self.description1 = getObject("Description1")
			self.description2 = getObject("Description2")

		except:
			import exception
			exception.Abort("InputDialogWithDescription.LoadBoardDialog.BindObject")

	def SetDescription1(self, text):
		self.description1.SetText(text)

	def SetDescription2(self, text):
		self.description2.SetText(text)

class QuestionDialogItem(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__CreateDialog()
	def __del__(self):
		ui.ScriptWindow.__del__(self)
	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialogitem.py")
		self.board = self.GetChild("board")
		self.textLine = self.GetChild("message")
		self.acceptButton = self.GetChild("accept")
		self.destroyButton = self.GetChild("destroy")
		self.sellButton = self.GetChild("sell")
		self.cancelButton = self.GetChild("cancel")
	def Open(self):
		self.SetCenterPosition()
		self.SetTop()
		self.Show()
	def Close(self):
		self.Hide()
	def SetWidth(self, width):
		height = self.GetHeight()
		self.SetSize(width, height)
		self.board.SetSize(width, height)
		self.SetCenterPosition()
		self.UpdateRect()
	def SAFE_SetAcceptEvent(self, event):
		self.acceptButton.SAFE_SetEvent(event)
	def SAFE_SetCancelEvent(self, event):
		self.cancelButton.SAFE_SetEvent(event)
	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
	def SetDestroyEvent(self, event):
		self.destroyButton.SetEvent(event)
	def SetSellEvent(self, event):
		self.sellButton.SetEvent(event)
	def SetCancelEvent(self, event):
		self.cancelButton.SetEvent(event)
	def SetText(self, text):
		self.textLine.SetText(text)
	def SetAcceptText(self, text):
		self.acceptButton.SetText(text)
	def SetCancelText(self, text):
		self.cancelButton.SetText(text)
	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

		
class QuestionDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__CreateDialog()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialog.py")

		self.board = self.GetChild("board")
		self.textLine = self.GetChild("message")
		self.acceptButton = self.GetChild("accept")
		self.cancelButton = self.GetChild("cancel")

	def Open(self):
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.Hide()

	def SetWidth(self, width):
		height = self.GetHeight()
		self.SetSize(width, height)
		self.board.SetSize(width, height)
		self.SetCenterPosition()
		self.UpdateRect()

	def SAFE_SetAcceptEvent(self, event):
		self.acceptButton.SAFE_SetEvent(event)

	def SAFE_SetCancelEvent(self, event):
		self.cancelButton.SAFE_SetEvent(event)

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)

	def SetCancelEvent(self, event):
		self.cancelButton.SetEvent(event)

	def SetText(self, text):
		self.textLine.SetText(text)

	def SetAcceptText(self, text):
		self.acceptButton.SetText(text)

	def SetCancelText(self, text):
		self.cancelButton.SetText(text)

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE
				
class QuestionDialogEfsun(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.__CreateDialog()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialogefsun.py")

		self.board = self.GetChild("board")
		self.textLine = self.GetChild("message")
		self.acceptButton = self.GetChild("accept")
		self.cancelButton = self.GetChild("cancel")
		#self.cancel2Button = self.GetChild("cancel2")

	def Open(self):
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.Hide()

	def SetWidth(self, width):
		height = self.GetHeight()
		self.SetSize(width, height)
		self.board.SetSize(width, height)
		self.SetCenterPosition()
		self.UpdateRect()

	def SAFE_SetAcceptEvent(self, event):
		self.acceptButton.SAFE_SetEvent(event)

	def SAFE_SetCancelEvent(self, event):
		self.cancelButton.SAFE_SetEvent(event)

	# def SAFE_SetCancel2Event(self, event):
		# self.cancel2Button.SAFE_SetEvent(event)	
		
	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)

	def SetCancelEvent(self, event):
		self.cancelButton.SetEvent(event)

	# def SetCancel2Event(self, event):
		# self.cancel2Button.SetEvent(event)	
		
	def SetText(self, text):
		self.textLine.SetText(text)

	def SetAcceptText(self, text):
		self.acceptButton.SetText(text)

	def SetCancelText(self, text):
		self.cancelButton.SetText(text)

	# def SetCancel2Text(self, text):
		# self.cancel2Button.SetText(text)	
		
	def OnPressEscapeKey(self):
		self.Close()
		return TRUE		

class QuestionDialogExchange(QuestionDialog):

	def __init__(self):
		QuestionDialog.__init__(self)
		self.__CreateDialog()

	def __del__(self):
		QuestionDialog.__del__(self)

	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialogticaret.py")

		self.board = self.GetChild("board")
		self.textLine1 = self.GetChild("message1")
		self.textLine2 = self.GetChild("message2")
		self.acceptButton = self.GetChild("accept")
		self.cancelButton = self.GetChild("cancel")
		self.what = self.GetChild("what")
		self.what.Hide()

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)	

	def SetCancelEvent(self, event):
		self.cancelButton.SetEvent(event)

	def SetWhatEvent(self, event):
		self.what.SetEvent(event)
		
	def SetText1(self, text):
		self.textLine1.SetText(text)

	def SetText2(self, text):
		self.textLine2.SetText(text)
		
	def whatcim(self, text):
		self.what.SetText(text)		
		
class QuestionDialogEnyakin(QuestionDialog):


    def __init__(self):
        QuestionDialog.__init__(self)
        self.__CreateDialog()


    def __del__(self):
        QuestionDialog.__del__(self)


    def __CreateDialog(self):
        pyScrLoader = ui.PythonScriptLoader()
        pyScrLoader.LoadScriptFile(self, "uiscript/enyakinisinlama.py")


        self.board = self.GetChild("board")
        self.textLine1 = self.GetChild("message1")
        self.textLine2 = self.GetChild("message2")
        self.textLine3 = self.GetChild("message3")
        self.acceptButton = self.GetChild("accept")
        self.cancelButton = self.GetChild("cancel")


    def SetText1(self, text):
        self.textLine1.SetText(text)


    def SetText2(self, text):
        self.textLine2.SetText(text)
    
    def SetText3(self, text):
        self.textLine3.SetText(text)
		
class QuestionDialog2(QuestionDialog):

	def __init__(self):
		QuestionDialog.__init__(self)
		self.__CreateDialog()

	def __del__(self):
		QuestionDialog.__del__(self)

	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialog2.py")

		self.board = self.GetChild("board")
		self.textLine1 = self.GetChild("message1")
		self.textLine2 = self.GetChild("message2")
		self.acceptButton = self.GetChild("accept")
		self.cancelButton = self.GetChild("cancel")

	def SetText1(self, text):
		self.textLine1.SetText(text)

	def SetText2(self, text):
		self.textLine2.SetText(text)

class QuestionDialogWithTimeLimit(QuestionDialog2):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()
		self.endTime = 0

	def __del__(self):
		QuestionDialog2.__del__(self)

	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialog2.py")

		self.board = self.GetChild("board")
		self.textLine1 = self.GetChild("message1")
		self.textLine2 = self.GetChild("message2")
		self.acceptButton = self.GetChild("accept")
		self.cancelButton = self.GetChild("cancel")

	def Open(self, msg, timeout):
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

		self.SetText1(msg)
		self.endTime = app.GetTime() + timeout

	def OnUpdate(self):
		leftTime = max(0, self.endTime - app.GetTime())
		self.SetText2(localeInfo.UI_LEFT_TIME % (leftTime))

		board = self.GetChild("board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputValue = getObject("InputValue")
		#self.inputValue.SetNumberMode()
		self.inputValue.OnIMEUpdate = ui.__mem_func__(self.__OnValueUpdate)
		self.moneyText = getObject("MoneyValue")

	def Open(self):
		self.inputValue.SetText("")
		self.inputValue.SetFocus()
		self.__OnValueUpdate()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputValue = None
		self.Hide()

	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		self.inputValue.SetMax(length)
		self.inputValue.SetUserMax(length)

	def SetMoneyHeaderText(self, text):
		self.moneyHeaderText = text

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event

	def SetValue(self, value):
		value=str(value)
		self.inputValue.SetText(value)
		self.__OnValueUpdate()
		ime.SetCursorPosition(len(value))		


	def GetText(self):
		return self.inputValue.GetText()

	def __OnValueUpdate(self):
		ui.EditLine.OnIMEUpdate(self.inputValue)

		text = self.inputValue.GetText()
		for i in xrange(len(text)):
			if not text[i].isdigit():
				text=text[0:i]+text[i+1:]
				self.inputValue.SetText(text)
		self.moneyText.SetText(self.moneyHeaderText + localeInfo.NumberToMoneyString(text))

class MoneyInputDialog(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.moneyHeaderText = localeInfo.MONEY_INPUT_DIALOG_SELLPRICE
		self.__CreateDialog()
		self.SetMaxLength(11)

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/moneyinputdialog.py")

		getObject = self.GetChild
		self.board = self.GetChild("board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputValue = getObject("InputValue")
		self.inputValue.SetNumberMode()
		self.inputValue.OnIMEUpdate = ui.__mem_func__(self.__OnValueUpdate)
		self.moneyText = getObject("MoneyValue")

	def Open(self):
		self.inputValue.SetText("")
		self.inputValue.SetFocus()
		self.__OnValueUpdate()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputValue = None
		self.Hide()

	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		length = min(11, length)
		self.inputValue.SetMax(length)

	def SetMoneyHeaderText(self, text):
		self.moneyHeaderText = text

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event

	def SetValue(self, value):
		value=str(value)
		self.inputValue.SetText(value)
		self.__OnValueUpdate()
		ime.SetCursorPosition(len(value))		


	def GetText(self):
		return self.inputValue.GetText()

	def __OnValueUpdate(self):
		ui.EditLine.OnIMEUpdate(self.inputValue)

		text = self.inputValue.GetText()

		money = 0
		if text and text.isdigit():
			try:
				money = long(text)
			except ValueError:
				money = 199999999999

		self.moneyText.SetText(self.moneyHeaderText + localeInfo.NumberToMoneyString(money))
		
	def __OnValueUpdate1(self):
		ui.EditLine.OnIMEUpdate(self.inputValue1)

		text = self.inputValue1.GetText()

		money = 0
		if text and text.isdigit():
			try:
				money = int(text)
			except ValueError:
				money = 299999999

		self.moneyText1.SetText("Pret de vanzare:"+str(money)+" EP")
		
	def __OnValueUpdate2(self):
		ui.EditLine.OnIMEUpdate(self.inputValue2)

		text = self.inputValue2.GetText()

		money = 0
		if text and text.isdigit():
			try:
				money = int(text)
			except ValueError:
				money = 299999999

		self.moneyText2.SetText("Pret de vanzare:"+str(money)+" Won")

class QuestionDialogWithTimeLimit2(QuestionDialog2):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()
		self.endTime = 0

	def __del__(self):
		QuestionDialog2.__del__(self)

	def __CreateDialog(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/questiondialog2.py")

		self.board = self.GetChild("board")
		self.textLine1 = self.GetChild("message1")
		self.textLine2 = self.GetChild("message2")
		self.acceptButton = self.GetChild("accept")
		self.cancelButton = self.GetChild("cancel")

	def Open(self, msg, timeout):
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

		self.SetText1(msg)
		self.endTime = app.GetTime() + timeout

	def OnUpdate(self):
		leftTime = max(0, self.endTime - app.GetTime())
		self.SetText2(localeInfo.UI_LEFT_TIME % (leftTime))
		
class MoneyInputDialogCheque(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.moneyHeaderText = localeInfo.MONEY_INPUT_DIALOG_SELLPRICE
		self.__CreateDialog()
		self.SetMaxLength(12)
		self.SetMaxLengthCheque(3)

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/moneyinputdialogcheque.py")

		getObject = self.GetChild
		self.board = self.GetChild("board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputValue = getObject("InputValue")
		self.inputValue.SetNumberMode()
		self.inputValue.OnIMEUpdate = ui.__mem_func__(self.__OnValueUpdate)
		self.moneyText = getObject("MoneyValue")
		self.SellInfoText = getObject("SellInfoText")
		self.InputValue_Cheque = getObject("InputValue_Cheque")
		self.InputValue_Cheque.SetNumberMode()
		self.InputValue_Cheque.OnIMEUpdate = ui.__mem_func__(self.__OnChequeValueUpdate)
		self.chequeText = getObject("ChequeValue")

	def Open(self):
		self.inputValue.SetText("0")
		self.inputValue.SetFocus()
		self.__OnChequeValueUpdate()
		self.InputValue_Cheque.SetText("0")
		self.__OnValueUpdate()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputValue = None
		self.InputValue_Cheque = None
		self.Hide()

	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		length = min(12, length)
		self.inputValue.SetMax(length)

	def SetMoneyHeaderText(self, text):
		self.moneyHeaderText = text

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event

	def SetValue(self, value):
		value=str(value)
		self.inputValue.SetText(value)
		self.__OnValueUpdate()
		ime.SetCursorPosition(len(value))		


	def GetText(self):
		return self.inputValue.GetText()
		
	def SetChequeValue(self, value):
		value=str(value)
		self.InputValue_Cheque.SetText(value)
		self.InputValue_Cheque.SetFocus()
		self.__OnChequeValueUpdate()
		ime.SetCursorPosition(len(value))
		
	def SetMaxLengthCheque(self, length):
		length = min(3, length)
		self.InputValue_Cheque.SetMax(length)
		
	def GetChequeText(self):
		return self.InputValue_Cheque.GetText()
		
	def __OnChequeValueUpdate(self):
		ui.EditLine.OnIMEUpdate(self.InputValue_Cheque)

		text = self.InputValue_Cheque.GetText()
		
		cheque = 0
		if text and text.isdigit():
			try:
				cheque = int(text)
			except ValueError:
				cheque = 999

		self.chequeText.SetText(localeInfo.NumberToChequeString(cheque))

	def __OnValueUpdate(self):
		ui.EditLine.OnIMEUpdate(self.inputValue)

		text = self.inputValue.GetText()

		money = 0
		if text and text.isdigit():
			try:
				money = long(text)
			except ValueError:
				money = 199999999

		self.moneyText.SetText(localeInfo.NumberToMoneyString(money))
		
class InputDialogName(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/inputdialog_name.py")

		getObject = self.GetChild
		self.board = getObject("Board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputSlot = getObject("InputSlot")
		self.inputValue = getObject("InputValue")

	def Open(self):
		self.inputValue.SetFocus()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputSlot = None
		self.inputValue = None
		self.Hide()

	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetNumberMode(self):
		self.inputValue.SetNumberMode()

	def SetSecretMode(self):
		self.inputValue.SetSecret()

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		width = length * 6 + 10
		self.SetBoardWidth(max(width + 50, 160))
		self.SetSlotWidth(width)
		self.inputValue.SetMax(length)

	def SetSlotWidth(self, width):
		self.inputSlot.SetSize(width, self.inputSlot.GetHeight())
		self.inputValue.SetSize(width, self.inputValue.GetHeight())
		if self.IsRTL():
			self.inputValue.SetPosition(self.inputValue.GetWidth(), 0)

	def SetBoardWidth(self, width):
		self.SetSize(max(width + 50, 160), self.GetHeight())
		self.board.SetSize(max(width + 50, 160), self.GetHeight())	
		if self.IsRTL():
			self.board.SetPosition(self.board.GetWidth(), 0)
		self.UpdateRect()

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event

	def GetText(self):
		return self.inputValue.GetText()
		
class MoneyInputDialog2(ui.ScriptWindow):

	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self._moneyHeaderText = localeInfo.MONEY_INPUT_DIALOG_SELLPRICE
		self._BarHeaderText = localeInfo.MONEY_INPUT_DIALOG_SELLPRICE
		self.__CreateDialog()
		self.SetMaxLength(9)

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		_pyScrLoader = ui.PythonScriptLoader()
		_pyScrLoader.LoadScriptFile(self, "uiscript/moneyinputdialog2.py")

		_getObject = self.GetChild
		self._board = self.GetChild("board")
		self._acceptButton = _getObject("AcceptButton")
		self._cancelButton = _getObject("CancelButton")
		self._inputValue = _getObject("InputValue")
		self._barValue = _getObject("BarValue1")
		self._inputValue.SetNumberMode()
		self._barValue.SetNumberMode()
		self._inputValue.OnIMEUpdate = ui.__mem_func__(self.__OnValueUpdate)
		self._barValue.OnIMEUpdate = ui.__mem_func__(self.__OnValueUpdate2)
		self._moneyText = _getObject("MoneyValue")
		self._barText = _getObject("BarValue")
		self._InputSlot2 = _getObject("InputSlot2")
		self._InputSlot = _getObject("InputSlot")
		self._BarPanel = _getObject("BarPanel")
		self._YangPanel = _getObject("YangPanel")
		self._board.SetSize(200,190)

		self._kapatbunlari()
		_box = DropDown(self,"Yang")
		_box.SetPosition(60,85)
		# _box.AppendItem("Iptal", 1)
		# _box.AppendItem(localeInfo.OFFLINE_SHOP_BAR50M, 1)
		# _box.AppendItem(localeInfo.OFFLINE_SHOP_BAR100M, 2)
		# _box.AppendItem(localeInfo.OFFLINE_SHOP_BAR250M, 3)
		# _box.AppendItem(localeInfo.OFFLINE_SHOP_SOULSTONE, 4)
		# _box.AppendItem(localeInfo.OFFLINE_SHOP_DRAGONSTAMP, 5)
		# _box.AppendItem(localeInfo.OFFLINE_SHOP_DRAGONCLAW, 6)
		if app.ENABLE_CHEQUE_SYSTEM:
			_box.AppendItem(localeInfo.OFFLINE_SHOP_CHEQUE, 7)
		_box.OnChange=self._birimver
		_box.SetSize(110,20)
		_box.Show()
		self._box = _box
		self._type = 0

	def _birimver(self):
		_secili = self._box.DropList.GetSelectedItem().value
		# chat.AppendChat(1, "%s" % (secili))
		self._kapatbunlari()
		if _secili == 0:
			self._box.SetPosition(60,85)
			chat.AppendChat(1, localeInfo.OFFLINE_SHOP_MONEY_NOTSELECTED)
			self._kapatbunlari()
			self._board.SetSize(200,190)
		# elif _secili == 1:
			# self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_BAR50M_COUNT)
		# elif _secili == 2:
			# self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_BAR100M_COUNT)
		# elif _secili == 3:
			# self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_BAR250M_COUNT)
		# elif _secili == 4:
			# self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_SOULSTONE_COUNT)
		# elif _secili == 5:
			# self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_DRAGONSTAMP_COUNT)
		# elif _secili == 6:
			# self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_DRAGONCLAW_COUNT)
		elif _secili == 7 and app.ENABLE_CHEQUE_SYSTEM:
			self._BarPanel.SetText(localeInfo.OFFLINE_SHOP_CHEQUE_COUNT)

		if _secili != 0:
			self._box.SetPosition(60,155)
			self._board.SetSize(200,190)
			self._barText.Show()
			self._barValue.Show()
			self._InputSlot2.Show()
			self._BarPanel.Show()
			self._barValue.SetText("0")
			self.__OnValueUpdate2()

	def _kapatbunlari(self):
		self._barText.Hide()
		self._barValue.Hide()
		self._InputSlot2.Hide()
		self._BarPanel.Hide()
		
	def Open(self):
		self._inputValue.SetText("0")
		self._barValue.SetText("0")
		self._inputValue.SetFocus()
		self.__OnValueUpdate()
		self.__OnValueUpdate2()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()
		
	def Close(self):
		self.ClearDictionary()
		self._board = None
		self._acceptButton = None
		self._cancelButton = None
		self._inputValue = None
		self._barValue = None
		self.Hide()

	def SetTitle(self, name):
		self._board.SetTitleName(name)

	def SetFocus(self):
		self._inputValue.SetFocus()

	def SetMaxLength(self, length):
		length = min(9, length)
		self._inputValue.SetMax(length)
		# self.barValue.SetMax(length)

	def SetMoneyHeaderText(self, text):
		self._moneyHeaderText = text
	def SetBarHeaderText(self, text):
		self._BarHeaderText = text

	def SetAcceptEvent(self, event):
		self._acceptButton.SetEvent(event)
		self._inputValue.OnIMEReturn = event
		self._barValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self._board.SetCloseEvent(event)
		self._cancelButton.SetEvent(event)
		self._inputValue.OnPressEscapeKey = event
		self._barValue.OnPressEscapeKey = event

	def SetValue(self, value):
		value=str(value)
		self._inputValue.SetText(value)
		self.__OnValueUpdate()
		ime.SetCursorPosition(len(value))		
		
	def SetValue2(self, value):
		value=str(value)
		self._barValue.SetText(value)
		self.__OnValueUpdate2()
		ime.SetCursorPosition(len(value))		

	def GetText(self):
		return self._inputValue.GetText()
		
	def GetText2(self):
		return self._barValue.GetText()
		
	def GetText2Type(self):
		return self._box.DropList.GetSelectedItem().value

	def __OnValueUpdate(self):
		ui.EditLine.OnIMEUpdate(self._inputValue)

		text = self._inputValue.GetText()

		_money = 0
		if text and text.isdigit():
			try:
				_money = int(text)
			except ValueError:
				_money = 199999999

		self._moneyText.SetText(self._moneyHeaderText + localeInfo.NumberToMoneyString(_money))
		
	def __OnValueUpdate2(self):
		ui.EditLine.OnIMEUpdate(self._barValue)
		ia = self.GetText2()
		
		if len(ia) > 4:
			self._barValue.SetText("0")

		text = self._barValue.GetText()

		bar = 0
		type = self._box.DropList.GetSelectedItem().value
		if text and text.isdigit():
			try:
				bar = int(text)
			except ValueError:
				bar = 199999999

		self._barText.SetText(self._BarHeaderText + self.nmto(bar, type))
		
	def nmto(self,n,a):
		birim =""
		# if a == 1:
			# birim = localeInfo.OFFLINE_SHOP_BAR50M_TOTAL
		# if a == 2:
			# birim = localeInfo.OFFLINE_SHOP_BAR100M_TOTAL
		# if a == 3:
			# birim = localeInfo.OFFLINE_SHOP_BAR250M_TOTAL
		# if a == 4:
			# birim = localeInfo.OFFLINE_SHOP_SOULSTONE_TOTAL
		# if a == 5:
			# birim = localeInfo.OFFLINE_SHOP_DRAGONSTAMP_TOTAL
		# if a == 6:
			# birim = localeInfo.OFFLINE_SHOP_DRAGONCLAW_TOTAL
		if a == 7 and app.ENABLE_CHEQUE_SYSTEM:
			birim = localeInfo.OFFLINE_SHOP_CHEQUE_TOTAL
		if n <= 0 :
			return "0 %s" % (birim)

		return "%s %s" % ('.'.join([ i-3<0 and str(n)[:i] or str(n)[i-3:i] for i in range(len(str(n))%3, len(str(n))+1, 3) if i ]), birim) 
		
class InputDialogShop(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)

		self.__CreateDialog()
		self.style = 0

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def __CreateDialog(self):

		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/inputdialogshop.py")

		getObject = self.GetChild
		self.board = getObject("Board")
		self.acceptButton = getObject("AcceptButton")
		self.cancelButton = getObject("CancelButton")
		self.inputSlot = getObject("InputSlot")
		self.inputValue = getObject("InputValue")
		self.inputStyle0 = getObject("InputStyle0")
		
		self.inputStyle0.SetEvent(self.__ChangeInputStyle0)
		
		
	def Open(self):
		self.inputValue.SetFocus()
		self.__ChangeInputStyle0()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()
		

	def Close(self):
		self.ClearDictionary()
		self.board = None
		self.acceptButton = None
		self.cancelButton = None
		self.inputSlot = None
		self.inputValue = None
		self.inputStyle0 = None

		self.time = 0
		self.Hide()
		
	def SetTitle(self, name):
		self.board.SetTitleName(name)

	def SetNumberMode(self):
		self.inputValue.SetNumberMode()

	def SetSecretMode(self):
		self.inputValue.SetSecret()

	def SetFocus(self):
		self.inputValue.SetFocus()

	def SetMaxLength(self, length):
		width = length * 6 + 10
		self.SetBoardWidth(max(width + 50, 160))
		self.SetSlotWidth(width)
		self.inputValue.SetMax(length)

	def SetSlotWidth(self, width):
		self.inputSlot.SetSize(width, self.inputSlot.GetHeight())
		self.inputValue.SetSize(width, self.inputValue.GetHeight())
		if self.IsRTL():
			self.inputValue.SetPosition(self.inputValue.GetWidth(), 0)

	def SetBoardWidth(self, width):
		self.SetSize(max(width + 50, 160), self.GetHeight())
		self.board.SetSize(max(width + 50, 160), self.GetHeight())	
		if self.IsRTL():
			self.board.SetPosition(self.board.GetWidth(), 0)
		self.UpdateRect()

	def SetAcceptEvent(self, event):
		self.acceptButton.SetEvent(event)
		self.inputValue.OnIMEReturn = event

	def SetCancelEvent(self, event):
		self.board.SetCloseEvent(event)
		self.cancelButton.SetEvent(event)
		self.inputValue.OnPressEscapeKey = event
		
	def __ChangeInputStyle0(self):
		self.style = 0
		self.GetChild("InputStyle0").Down()
	
	def GetText(self):
		return self.inputValue.GetText()
		
	def GetStyle(self):
		return int(self.style)
		
class OnlinePopup(ui.BorderB):
	def __init__(self):
		ui.BorderB.__init__(self)
		
		self.isActiveSlide = False
		self.isActiveSlideOut = False
		self.endTime = 0
		self.wndWidth = 0

		self.textLine = ui.TextLine()
		self.textLine.SetParent(self)
		self.textLine.SetWindowHorizontalAlignCenter()
		self.textLine.SetWindowVerticalAlignCenter()
		self.textLine.SetHorizontalAlignCenter()
		self.textLine.SetVerticalAlignCenter()
		self.textLine.SetPosition(13, 0)
		self.textLine.Show()
		
		self.onlineImage = ui.ImageBox()
		self.onlineImage.SetParent(self)
		self.onlineImage.SetPosition(8, 8)
		self.onlineImage.LoadImage("d:/ymir work/ui/game/windows/messenger_list_online.sub")
		self.onlineImage.Show()
		
	def __del__(self):
		ui.BorderB.__del__(self)

	def SlideIn(self):
		self.SetTop()
		self.Show()
		
		self.isActiveSlide = True
		self.endTime = app.GetGlobalTimeStamp() + 5

	def Close(self):
		self.Hide()

	def Destroy(self):
		self.Close()

	def SetUserName(self, name):
		self.textLine.SetText("Prietenul tau %s este online!" % str(name))
		
		self.wndWidth = self.textLine.GetTextSize()[0] + 40
		self.SetSize(self.wndWidth, 25)
		self.SetPosition(-self.wndWidth, wndMgr.GetScreenHeight() - 200)
		
	def OnUpdate(self):
		if self.isActiveSlide and self.isActiveSlide == True:
			x, y = self.GetLocalPosition()
			if x < 0:
				self.SetPosition(x + 4, y)
				
		if self.endTime - app.GetGlobalTimeStamp() <= 0 and self.isActiveSlideOut == False and self.isActiveSlide == True:
			self.isActiveSlide = False
			self.isActiveSlideOut = True
				
		if self.isActiveSlideOut and self.isActiveSlideOut == True:
			x, y = self.GetLocalPosition()
			if x > -(self.wndWidth):
				self.SetPosition(x - 4, y)
				
			if x <= -(self.wndWidth):
				self.isActiveSlideOut = False
				self.Close()

class DropDown(ui.Window):
	dropped  = 0
	dropstat = 0
	last = 0
	lastS = 0
	maxh = 95
	OnChange = None
	class Item(ui.ListBoxEx.Item):
		def __init__(self,parent, text,value=0):
			ui.ListBoxEx.Item.__init__(self)
			self.textBox=ui.TextLine()
			self.textBox.SetParent(self)
			self.textBox.SetText(text)
			# self.textBox.SetLimitWidth(parent.GetWidth()-132)
			self.textBox.Show()
			self.value = value
			
		def GetValue(self):
			return self.value
			
		def __del__(self):
			ui.ListBoxEx.Item.__del__(self)
			
	def __init__(self,parent,tt = "",down=1):
		ui.Window.__init__(self,"TOP_MOST")
		self.down = down
		self.SetParentProxy(parent)
		self.bg = ui.Bar("TOP_MOST")
		self.bg.SetParent(self)
		self.bg.SetPosition(0,0)
		self.bg.SetColor(0xc0000000)
		self.bg.OnMouseOverIn = self.bgMouseIn
		self.bg.OnMouseOverOut = self.bgMouseOut
		self.bg.OnMouseLeftButtonDown = self.ExpandMe
		self.bg.Show()
		self.act = ui.TextLine()
		self.act.SetParent(self.bg)
		self.act.SetPosition(4,2)
		self.act.SetText(tt)
		self.act.Show()
		self.GetText = self.act.GetText
		
		self.Drop = ui.Bar("TOP_MOST")
		self.Drop.SetParent(self.GetParentProxy())
		self.Drop.SetPosition(0,21)
		# self.Drop.SetSize(150,95)
		self.Drop.SetSize(150,0)
		# self.Drop.SetColor(0xc00a0a0a)
		self.Drop.SetColor(0xff0a0a0a)
		
		self.ScrollBar = ui.ThinScrollBar()
		self.ScrollBar.SetParent(self.Drop)
		self.ScrollBar.SetPosition(132,0)
		# self.ScrollBar.SetScrollBarSize(95)
		self.ScrollBar.SetScrollBarSize(0)
		# self.ScrollBar.Show()
		
		self.DropList = ui.ListBoxEx()
		self.DropList.SetParent(self.Drop)
		self.DropList.itemHeight = 12
		self.DropList.itemStep = 13
		self.DropList.SetPosition(0,0)
		# self.DropList.SetSize(132,self.maxh)
		self.DropList.SetSize(132,13) 
		self.DropList.SetScrollBar(self.ScrollBar)
		self.DropList.SetSelectEvent(self.SetTitle)
		self.DropList.SetViewItemCount(0)
		self.DropList.Show()
		if tt != "":
			self.AppendItemAndSelect(tt)
		self.selected = self.DropList.GetSelectedItem()
		self.SetSize(120,20)
		
	def __del__(self): 
		ui.Window.__del__(self)
	c = 1
	
	def GetSelect(self):
		return self.DropList.GetSelectedItem()
		
	def AppendItem(self,text,value=0):
		self.c+=1   
		self.DropList.AppendItem(self.Item(self,text,value))
		self.maxh = min(95,13*self.c)
		if self.c > 7:
			self.ScrollBar.Show()
		
	def AppendItemAndSelect(self,text,value=0):
		self.DropList.AppendItem(self.Item(self,text,value))
		self.DropList.SelectIndex(len(self.DropList.itemList)-1)
		
	def SelectByAffectId(self,id):
		for x in self.DropList.itemList:
			if x.value == id:
				self.DropList.SelectItem(x)
				break
				
	def SetTitle(self,item):
		self.act.SetText(str(item.textBox.GetText()))
		self.last = self.DropList.basePos
		self.lastS = self.ScrollBar.GetPos()
		self.dropped = 0
		self.selected = item
		self.GetSelect()
		if self.OnChange:
			self.OnChange()
		# self.Drop.Hide()
		
	def SetPosition(self,w,h):
		ui.Window.SetPosition(self,w,h)
		if self.down == 1:
			self.Drop.SetPosition(w,h+21)
		else:
			self.Drop.SetPosition(w,h-self.Drop.GetHeight())
		
	def SetSize(self,w,h):
		ui.Window.SetSize(self,w,h)
		self.bg.SetSize(w,h)
		self.Drop.SetSize(w,0)
		self.DropList.SetSize(w-18,self.maxh)
		for x in self.DropList.itemList:
			x.SetSize(w-18,12)
		self.ScrollBar.SetPosition(w-18,0)
		
	def kap(self):
		self.ScrollBar.Hide()
		self.Drop.Hide()
		
	def ExpandMe(self, a=0):
		if a==1:
			self.dropped = 1
		if self.dropped == 1:
			# self.Drop.Hide()
			self.dropped = 0
		else:
			# self.Drop.Show()
			self.dropped = 1
			
	def OnUpdate(self):
		iter = 6
		if self.Drop.GetHeight() < 50:
			self.ScrollBar.Hide()
		else:
			self.ScrollBar.Show()
			
		if self.dropped == 0 and self.dropstat == 1:
			if self.Drop.GetHeight() <=0:
				self.dropstat = 0
				self.Drop.SetSize(self.Drop.GetWidth(),0)
				self.ScrollBar.SetScrollBarSize(self.Drop.GetHeight())
				self.Drop.Hide()
			else:
				if self.Drop.GetHeight()-iter < 0:
					self.Drop.SetSize(self.Drop.GetWidth(),0)
				else:
					self.Drop.SetSize(self.Drop.GetWidth(),self.Drop.GetHeight()-iter)
					(w,h) = self.GetLocalPosition()
					self.SetPosition(w,h)
			
				self.ScrollBar.SetScrollBarSize(self.Drop.GetHeight())
			self.DropList.SetViewItemCount(int(self.Drop.GetHeight()/13))
			self.DropList.SetBasePos(self.last+1)
			self.DropList.SetBasePos(self.last)
		elif self.dropped == 1 and self.dropstat == 0:
			self.Drop.Show()
			self.SetTop()
			if self.Drop.GetHeight() >=self.maxh:
				self.Drop.SetSize(self.Drop.GetWidth(),self.maxh)
				self.ScrollBar.SetScrollBarSize(self.maxh)
				self.dropstat = 1
				self.DropList.SetViewItemCount(7)
				self.ScrollBar.SetPos(self.lastS)
			else:
				self.ScrollBar.SetScrollBarSize(self.Drop.GetHeight()+iter)
				self.Drop.SetSize(self.Drop.GetWidth(),self.Drop.GetHeight()+iter)
				(w,h) = self.GetLocalPosition()
				self.SetPosition(w,h)
			self.DropList.SetViewItemCount(int(self.Drop.GetHeight()/13))
			self.DropList.SetBasePos(self.last+1)
			self.DropList.SetBasePos(self.last)
		
	## BG Hover
	def bgMouseIn(self):
		self.bg.SetColor(0xc00a0a0a)
		
	def bgMouseOut(self):
		self.bg.SetColor(0xc0000000)

"""class CostumEffectDialog(ui.ScriptWindow):
		def __init__(self):
			ui.ScriptWindow.__init__(self)
			self.__effectButtons = {}
			self.selectEffect = -99
			self.targetSlotPos = 0
			self.metinSlotPos = 0
			self.effectColor = ["Sari","Beyaz","Mor","Kirmizi","Turuncu","Yesil","Mavi"]

		def __del__(self):
			ui.ScriptWindow.__del__(self)

		def Destroy(self):
			self.ClearDictionary()
			self.__effectButtons = {}
			self.selectEffect = -99
			self.targetSlotPos = 0
			self.metinSlotPos = 0

		def __LoadDialog(self):
			try:
				PythonScriptLoader = ui.PythonScriptLoader()
				PythonScriptLoader.LoadScriptFile(self, "UIScript/CostumeEffectSelectDialog.py")
			except:
				import exception
				exception.Abort("CostumEffectDialog.__LoadDialog.LoadObject")

			try:
				self.CostumEffectBoard = self.GetChild("CostumEffectBoard")
				self.BlackBoard = self.GetChild("BlackBoard")
				self.AcceptButton = self.GetChild("AcceptButton")
				
				self.GetChild("CostumEffectTitle").SetCloseEvent(self.Close)
				self.AcceptButton.SetEvent(self.AcceptButtonSelect)
			except:
				import exception
				exception.Abort("CostumEffectDialog.__LoadDialog.BindObject")

			y=46
			y_Son=0
			for i in xrange(len(self.effectColor)):
				self.__effectButtons[i] = ui.MakeButton(self, 20, y , "", "d:/ymir work/ui/game/myshop_deco/", "select_btn_01.sub", "select_btn_02.sub", "select_btn_03.sub")
				self.__effectButtons[i].SetText(str(self.effectColor[i]))
				self.__effectButtons[i].SetEvent(ui.__mem_func__(self.__SelectEffect),i)
				self.__effectButtons[i].Show()
				y+=28
				y_Son=i+1

			self.SetSize(self.GetWidth(),self.GetHeight()+(y_Son*28)+20)
			self.CostumEffectBoard.SetSize(self.CostumEffectBoard.GetWidth(),self.CostumEffectBoard.GetHeight()+(y_Son*28)+20)
			self.BlackBoard.SetSize(self.BlackBoard.GetWidth(),self.BlackBoard.GetHeight()+(y_Son*28)+5)
			self.AcceptButton.SetPosition(51, self.CostumEffectBoard.GetHeight()-37)

		def __SelectEffect(self, arg):
			for key,item in self.__effectButtons.iteritems():
				if key != arg:
					item.SetUp()
					item.Enable()
				else:
					item.Down()
					item.Disable()

			self.selectEffect = int(arg+1)

		def AcceptButtonSelect(self):
			import chat
			if self.selectEffect == -99:
				chat.AppendChat(chat.CHAT_TYPE_INFO, "Renk Secimi yapilmadi.")
				return FALSE
			
			import net
			net.SendChatPacket("/costumeffect %d %d %d" % (self.targetSlotPos, self.selectEffect, self.metinSlotPos))
			self.Close()
			
		def SlotPos(self, metinslot, slot):
			self.metinSlotPos = int(metinslot)
			self.targetSlotPos = int(slot)

		def Open(self):
			self.__LoadDialog()
			self.SetCenterPosition()
			ui.ScriptWindow.Show(self)
			self.__SelectEffect(0)

		def Close(self):
			self.Hide()
			return TRUE

		def OnPressEscapeKey(self):
			self.Close()
			return TRUE"""
