import net
import player
import item
import snd
import shop
import wndMgr
import app
import chat
import chr
import app
import ui
import uiCommon
import uiToolTip
import mouseModule
import localeInfo
import constInfo
import uiPickMoney
import interfaceModule

g_isEditingOfflineShop = False

def IsEditingOfflineShop():
	global g_isEditingOfflineShop
	if (g_isEditingOfflineShop):
		return True
	else:
		return False
		
###################################################################################################
## Offline Shop Manager
class OfflineShopManagerWindow(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.LoadWindow()
		self.tooltipItem = None
		self.priceInputBoard = None
		self.title = ""
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)
			
	def Refresh(self):
		net.SendRefreshOfflineShop()	
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			itemCount = shop.GetOfflineShopItemCount(i)
			if (itemCount <= 1):
				itemCount = 0
			self.itemSlot.SetItemSlot(i, shop.GetOfflineShopItemID(i), itemCount)
						
		wndMgr.RefreshSlot(self.itemSlot.GetWindowHandle())
		net.SendOfflineShopCheck()

	def SetItemData(self, pos, itemID, itemCount, itemPrice):
		shop.SetOfflineShopItemData(pos, itemID, itemCount, itemPrice)
		
	def LoadWindow(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/OfflineShopManagerDialog.py")
		except:
			import exception
			exception.Abort("OfflineShopManagerWindow.LoadWindow.LoadObject")
		try:
			self.itemSlot = self.GetChild("ItemSlot")
			self.titleBar = self.GetChild("TitleBar")
			self.board = self.GetChild("Board")
			self.refresh = self.GetChild("RefreshButton")
			self.btnDestroy = self.GetChild("DestroyButton")
			self.wndMapIndex = self.GetChild("MapIndex")
			#self.btnTeleport = self.GetChild("Teleport")
			self.wndTime = self.GetChild("Time")
			self.wndBank = self.GetChild("BankButton")
		except:
			import exception
			exception.Abort("OfflineShopManagerWindow.LoadWindow.BindObject")
			
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))
		self.refresh.SetEvent(ui.__mem_func__(self.Refresh))
		self.btnDestroy.SetEvent(ui.__mem_func__(self.DestroyShop))
		#self.btnTeleport.SetEvent(ui.__mem_func__(self.TeleportShop))
		self.wndBank.SetEvent(ui.__mem_func__(self.OpenBank))

		self.itemSlot.SetOverInItemEvent(ui.__mem_func__(self.OverInItem))
		self.itemSlot.SetOverOutItemEvent(ui.__mem_func__(self.OverOutItem))
		self.itemSlot.SetSelectEmptySlotEvent(ui.__mem_func__(self.SelectEmptySlot))
		self.itemSlot.SAFE_SetButtonEvent("RIGHT", "EXIST", self.UnselectItemSlot)
		
		wndOfflineShopMyBank = OfflineShopBankDialog()
		self.wndOfflineShopMyBank = wndOfflineShopMyBank
		
	def Destroy(self):
		self.ClearDictionary()
		
		self.itemSlot = None
		self.refresh = None
		self.wndMoney = None
		self.wndMoneySlot = None
		self.btnClose = None
		self.board = None
		
	def Open(self, i, time):
		self.wndMapIndex.SetText("Locatie: " + localeInfo.NumberToMapName(i))
		self.wndTime.SetText("Timp ramas: " + localeInfo.SecondToDHM(int(time)-app.GetGlobalTimeStamp()))
		self.tooltipItem = uiToolTip.ItemToolTip()
		self.tooltipItem.Hide()
		self.Refresh()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()
		
		global g_isEditingOfflineShop
		g_isEditingOfflineShop = True
		
	# def TeleportShop(self):
		# self.Close()
		# net.SendOfflineShopTeleportPacket()
				
	def DestroyShop(self):
		self.Close()
		closeQuestionDialog = uiCommon.QuestionDialog()
		closeQuestionDialog.SetText(localeInfo.DO_YOU_WANT_TO_CLOSE_OFFLINE_SHOP)
		closeQuestionDialog.SetAcceptEvent(lambda arg = True: self.AnswerDestroyShop(arg))
		closeQuestionDialog.SetCancelEvent(lambda arg = False: self.AnswerDestroyShop(arg))
		closeQuestionDialog.Open()
		self.closeQuestionDialog = closeQuestionDialog
		
	def OpenBank(self):
		self.wndOfflineShopMyBank.Open()
				
	def AnswerDestroyShop(self, flag):
		if (flag):
			net.SendDestroyOfflineShop()
			shop.ClearOfflineShopStock()
		else:
			self.Show()
			
		self.closeQuestionDialog = None		
		
	def Close(self):
		global g_isEditingOfflineShop
		g_isEditingOfflineShop = False
		
		self.title = ""
		self.Hide()
		
	def OnPressEscapeKey(self):
		self.Close()
		return True
		
	def OnPressExitKey(self):
		self.Close()
		return True
		
	def SelectEmptySlot(self, slotIndex):
		try:
			if (constInfo.GET_ITEM_QUESTION_DIALOG_STATUS() == 1):
				return
				
			if (mouseModule.mouseController.isAttached()):
				attachedSlotType = mouseModule.mouseController.GetAttachedType()
				attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
				mouseModule.mouseController.DeattachObject()
				
				if (player.SLOT_TYPE_INVENTORY != attachedSlotType and player.SLOT_TYPE_DRAGON_SOUL_INVENTORY != attachedSlotType and player.SLOT_TYPE_SKILL_BOOK_INVENTORY != attachedSlotType and player.SLOT_TYPE_UPGRADE_ITEMS_INVENTORY != attachedSlotType and player.SLOT_TYPE_STONE_INVENTORY != attachedSlotType and player.SLOT_TYPE_GIFT_BOX_INVENTORY != attachedSlotType):
					return
					
				attachedInvenType = player.SlotTypeToInvenType(attachedSlotType)
				itemVnum = player.GetItemIndex(attachedInvenType, attachedSlotPos)
				item.SelectItem(itemVnum)
				
				if (item.IsAntiFlag(item.ANTIFLAG_GIVE) or item.IsAntiFlag(item.ANTIFLAG_MYSHOP)):
					chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OFFLINE_SHOP_CANNOT_SELL_ITEM)
					return
					
				priceInputBoard = uiCommon.MoneyInputDialog2()
				priceInputBoard.SetTitle(item.GetItemName() + " " + localeInfo.OFFLINE_SHOP_PRICE)
				priceInputBoard.SetAcceptEvent(ui.__mem_func__(self.AcceptInputPrice))
				priceInputBoard.SetCancelEvent(ui.__mem_func__(self.CancelInputPrice))
				priceInputBoard.Open()			
				
				self.priceInputBoard = priceInputBoard
				self.priceInputBoard.itemVNum = itemVnum
				self.priceInputBoard.bDisplayPos = slotIndex
				self.priceInputBoard.attachedInvenType = attachedInvenType
				self.priceInputBoard.bPos = attachedSlotPos
		except Exception, e:
			import dbg
			dbg.TraceError("Exception : SelectEmptySlot, %s" %(e))
			
	def AcceptInputPrice(self):
		if (not self.priceInputBoard):
			return True
			
		text = self.priceInputBoard.GetText()
		text2 = self.priceInputBoard.GetText2()
		text2type = self.priceInputBoard.GetText2Type()
		
		if not text:
			return True

		if not text.isdigit():
			return True
			
		if text2 and int(text2) >= 1000:
			chat.AppendChat(1, "1000'den Yksek bir say giremezsiniz.")
			return True
			
		itvnm = self.priceInputBoard.itemVNum
		item.SelectItem(itvnm)
		itemname = item.GetItemName()
		if int(text2type) == 1:
			if int(itvnm) == 80005:
				self.uyarim(itemname)
				return True
		elif int(text2type) == 2:
			if int(itvnm) == 80006:
				self.uyarim(itemname)
				return True
		elif int(text2type) == 3:
			if int(itvnm) == 80007:
				self.uyarim(itemname)
				return True
		elif int(text2type) == 4:
			if int(itvnm) == 50513:
				self.uyarim(itemname)
				return True
		elif int(text2type) == 5:
			if int(itvnm) == 71123:
				self.uyarim(itemname)
				return True
		elif int(text2type) == 6:
			if int(itvnm) == 71129:
				self.uyarim(itemname)
				return True
			
		price = int(self.priceInputBoard.GetText())
		price2 = int(self.priceInputBoard.GetText2())
		price2type = int(self.priceInputBoard.GetText2Type())
		net.SendAddOfflineShopItem(self.priceInputBoard.bPos, self.priceInputBoard.bDisplayPos, price, price2, price2type, self.priceInputBoard.attachedInvenType)
		snd.PlaySound("sound/ui/drop.wav")
		self.Refresh()
		self.priceInputBoard.Close()
		self.priceInputBoard = None
		return True
		
	def CancelInputPrice(self):
		self.priceInputBoard.Close()
		self.priceInputBoard = None
		return True
		
	def uyarim(self, itemad):
		# chat.AppendChat(1, translate.uyarim %(str(itemad),str(itemad)))
		# self.priceInputBoard.Close()
		self.uyari2 = uiCommon.PopupDialog()
		self.uyari2.SetText(localeInfo.SHOP_WARNING_MULTI_PRICE %(str(itemad),str(itemad)))
		self.uyari2.Open()
		
	def UnselectItemSlot(self, selectedSlotPos):
		if (constInfo.GET_ITEM_QUESTION_DIALOG_STATUS() == 1):
			return
			
		itemIndex = shop.GetOfflineShopItemID(selectedSlotPos)
		item.SelectItem(itemIndex)
		itemName = item.GetItemName()
		
		questionDialog = uiCommon.QuestionDialog()
		questionDialog.SetText(localeInfo.DO_YOU_WANT_TO_REMOVE_ITEM % (itemName))
		questionDialog.SetAcceptEvent(lambda arg = True : self.AnswerRemoveItem(arg))
		questionDialog.SetCancelEvent(lambda arg = False : self.AnswerRemoveItem(arg))
		questionDialog.Open()
		questionDialog.pos = selectedSlotPos
		self.questionDialog = questionDialog
		
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(1)
		
	def AnswerRemoveItem(self, flag):
		if (flag):
			pos = self.questionDialog.pos
			net.SendRemoveOfflineShopItem(pos)
			net.SendOfflineShopCheck()
			
		self.questionDialog.Close()
		self.questionDialog = None
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(0)
		self.Refresh()
		
	def SetItemToolTip(self, tooltipItem):
		self.tooltipItem = tooltipItem
		
	def OverInItem(self, slotIndex):
		if (mouseModule.mouseController.isAttached()):
			return
			
		if (self.tooltipItem != 0):
			self.tooltipItem.SetOfflineShopItem(slotIndex)
			
	def OverOutItem(self):
		if (self.tooltipItem != 0):
			self.tooltipItem.HideToolTip()
			
	def OnUpdate(self):
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			itemCount = shop.GetOfflineShopItemCount(i)
			if (itemCount <= 1):
				itemCount = 0
				
			self.itemSlot.SetItemSlot(i, shop.GetOfflineShopItemID(i), itemCount)
			
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			vnum = shop.GetOfflineShopItemVnum(i)
			item.SelectItem(vnum)
			(itemWidth, itemHeight) = item.GetItemSize()
			if shop.GetOfflineShopItemStatus(i) == 2:
				if itemHeight == 1:
					self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlot.EnableSlot(i)
				elif itemHeight == 2:
					self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlot.EnableSlot(i)
				elif itemHeight == 3:
					self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlot.EnableSlot(i)
			else:
				self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/game/quest/slot_button_01.sub","d:/ymir work/ui/game/quest/slot_button_01.sub","d:/ymir work/ui/game/quest/slot_button_01.sub", "d:/ymir work/ui/pattern/slot_disable.tga", False, False)
				self.itemSlot.EnableSlot(i)	
							
		wndMgr.RefreshSlot(self.itemSlot.GetWindowHandle())
		if self.GetLeftItemCount() == 0:
			self.Close()
		
	def GetLeftItemCount(self):
		self.count = 0
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			if shop.GetOfflineShopItemID(i) != 0 and shop.GetOfflineShopItemStatus(i) == 0:
				self.count += 1
		
		return self.count
				
class OfflineShopManagerWindow2(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.LoadWindow()
		self.tooltipItem = None
		self.priceInputBoard = None
		self.title = ""
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)
			
	def Refresh(self):
		net.SendRefreshUnsoldItems()
		iCount = 0
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			if (shop.GetOfflineShopItemID(i) == -842150451):
				iCount = iCount + 1
				
		if (iCount == shop.OFFLINE_SHOP_SLOT_COUNT):
			return
			
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			itemCount = shop.GetOfflineShopItemCount(i)
			if (itemCount <= 1):
				itemCount = 0
					
			self.itemSlot.SetItemSlot(i, shop.GetOfflineShopItemID(i))
			
		wndMgr.RefreshSlot(self.itemSlot.GetWindowHandle())
		
	def SetItemData(self, pos, itemID, itemCount, itemPrice):
		shop.SetOfflineShopItemData(pos, itemID, itemCount, itemPrice)
		
	def LoadWindow(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/OfflineShopManagerDialog2.py")
		except:
			import exception
			exception.Abort("OfflineShopManagerWindow2.LoadWindow.LoadObject")
		try:
			self.itemSlot = self.GetChild("ItemSlot")
			self.titleBar = self.GetChild("TitleBar")
			self.board = self.GetChild("Board")
			self.refresh = self.GetChild("RefreshButton")
			self.wndBank = self.GetChild("BankButton")
		except:
			import exception
			exception.Abort("OfflineShopManagerWindow2.LoadWindow.BindObject")
			
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))
		self.refresh.SetEvent(ui.__mem_func__(self.Refresh))

		self.itemSlot.SetOverInItemEvent(ui.__mem_func__(self.OverInItem))
		self.itemSlot.SetOverOutItemEvent(ui.__mem_func__(self.OverOutItem))
		self.itemSlot.SAFE_SetButtonEvent("RIGHT", "EXIST", self.UnselectItemSlot)
		
		self.wndBank.SetEvent(ui.__mem_func__(self.OpenBank))
		
		wndOfflineShopMyBank = OfflineShopBankDialog()
		self.wndOfflineShopMyBank = wndOfflineShopMyBank
		
	def Destroy(self):
		self.ClearDictionary()
		
		self.nameLine = None
		self.itemSlot = None
		self.refresh = None
		self.wndMoney = None
		self.wndMoneySlot = None
		self.btnClose = None
		self.board = None
		
	def Open(self):
		self.tooltipItem = uiToolTip.ItemToolTip()
		self.tooltipItem.Hide()
		self.Refresh()
		self.SetCenterPosition()
		self.SetTop()
		self.Show()
		
		global g_isEditingOfflineShop
		g_isEditingOfflineShop = True
		
	def OpenBank(self):
		self.wndOfflineShopMyBank.Open()

	def Close(self):
		global g_isEditingOfflineShop
		g_isEditingOfflineShop = False
		
		self.title = ""
		self.Hide()
		
	def OnPressEscapeKey(self):
		self.Close()
		return True
		
	def OnPressExitKey(self):
		self.Close()
		return True
				
	def UnselectItemSlot(self, selectedSlotPos):
		if (constInfo.GET_ITEM_QUESTION_DIALOG_STATUS() == 1):
			return
			
		itemIndex = shop.GetOfflineShopItemID(selectedSlotPos)
		item.SelectItem(itemIndex)
		itemName = item.GetItemName()
		
		questionDialog = uiCommon.QuestionDialog()
		questionDialog.SetText(localeInfo.DO_YOU_WANT_TO_REMOVE_ITEM % (itemName))
		questionDialog.SetAcceptEvent(lambda arg = True : self.AnswerRemoveItem(arg))
		questionDialog.SetCancelEvent(lambda arg = False : self.AnswerRemoveItem(arg))
		questionDialog.Open()
		questionDialog.pos = selectedSlotPos
		self.questionDialog = questionDialog
		
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(1)
		
	def AnswerRemoveItem(self, flag):
		if (flag):
			pos = self.questionDialog.pos
			net.SendOfflineShopTakeItem(pos)
			
		self.questionDialog.Close()
		self.questionDialog = None
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(0)
		self.Refresh()
		
	def SetItemToolTip(self, tooltipItem):
		self.tooltipItem = tooltipItem
		
	def OverInItem(self, slotIndex):
		if (mouseModule.mouseController.isAttached()):
			return
			
		if (self.tooltipItem != 0):
			self.tooltipItem.SetOfflineShopItem(slotIndex)
			
	def OverOutItem(self):
		if (self.tooltipItem != 0):
			self.tooltipItem.HideToolTip()
			
	def OnUpdate(self):
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			itemCount = shop.GetOfflineShopItemCount(i)
			if (itemCount <= 1):
				itemCount = 0
				
			self.itemSlot.SetItemSlot(i, shop.GetOfflineShopItemID(i), itemCount)
			
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			vnum = shop.GetOfflineShopItemVnum(i)
			item.SelectItem(vnum)
			(itemWidth, itemHeight) = item.GetItemSize()
			if shop.GetOfflineShopItemStatus(i) == 2:
				if itemHeight == 1:
					self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlot.EnableSlot(i)
				elif itemHeight == 2:
					self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlot.EnableSlot(i)
				elif itemHeight == 3:
					self.itemSlot.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlot.EnableSlot(i)
					
		wndMgr.RefreshSlot(self.itemSlot.GetWindowHandle())
				
class OfflineShopBankDialog(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.updateTime = 0
		self.withdrawMoneyTime = 0
		self.LoadWindow()
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)
		
	def LoadWindow(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/OfflineShopBankDialog.py")
		except:
			import exception
			exception.Abort("OfflineShopBankDialog.LoadWindow.LoadScript")
			
		try:
			self.Board = self.GetChild("Board")
			self.wndMoney = self.GetChild("Money")
			self.wndMoneySlot = self.GetChild("Money_Slot")
			self.wndCheque = self.GetChild("Cheque")
			self.wndChequeSlot = self.GetChild("Cheque_Slot")
			# self.wndBar1 = self.GetChild("Bar1")
			# self.wndBar1Slot = self.GetChild("Bar1_Slot")
			# self.wndBar2 = self.GetChild("Bar2")
			# self.wndBar2Slot = self.GetChild("Bar2_Slot")
			# self.wndBar3 = self.GetChild("Bar3")
			# self.wndBar3Slot = self.GetChild("Bar3_Slot")
			# self.wndSoulStone = self.GetChild("SoulStone")
			# self.wndSoulStoneSlot = self.GetChild("SoulStone_Slot")
			# self.wndDragonScale = self.GetChild("DragonScale")
			# self.wndDragonScaleSlot = self.GetChild("DragonScale_Slot")
			# self.wndDragonClaw = self.GetChild("DragonClaw")
			# self.wndDragonClawSlot = self.GetChild("DragonClaw_Slot")
		except:
			import exception
			exception.Abort("OfflineShopBankDialog.LoadWindow.BindObject")
			
		self.Board.SetCloseEvent(ui.__mem_func__(self.Close))
		self.wndMoneySlot.SetEvent(ui.__mem_func__(self.OpenPickMoneyDialog))
		self.wndChequeSlot.SetEvent(ui.__mem_func__(self.OpenPickChequeDialog))
		# self.wndBar1Slot.SetEvent(ui.__mem_func__(self.OpenPickBar1Dialog))
		# self.wndBar2Slot.SetEvent(ui.__mem_func__(self.OpenPickBar2Dialog))
		# self.wndBar3Slot.SetEvent(ui.__mem_func__(self.OpenPickBar3Dialog))
		# self.wndSoulStoneSlot.SetEvent(ui.__mem_func__(self.OpenPickSoulStoneDialog))
		# self.wndDragonScaleSlot.SetEvent(ui.__mem_func__(self.OpenPickDragonScaleDialog))
		# self.wndDragonClawSlot.SetEvent(ui.__mem_func__(self.OpenPickDragonClawDialog))
		
	def Close(self):
		self.Hide()
		
	def Open(self):
		self.SetCenterPosition()
		self.SetTop()
		
		net.SendRefreshOfflineShopMoney()
		self.wndMoney.SetText(localeInfo.NumberToMoneyString(player.GetCurrentOfflineShopMoney()))
		self.wndCheque.SetText(localeInfo.NumberToChequeString(player.GetCurrentOfflineShopCheque()))
		# self.wndBar1.SetText(localeInfo.NumberToBar1String(player.GetCurrentOfflineShopBar1()))
		# self.wndBar2.SetText(localeInfo.NumberToBar2String(player.GetCurrentOfflineShopBar2()))
		# self.wndBar3.SetText(localeInfo.NumberToBar3String(player.GetCurrentOfflineShopBar3()))
		# self.wndSoulStone.SetText(localeInfo.NumberToSoulStoneString(player.GetCurrentOfflineShopSoulStone()))
		# self.wndDragonScale.SetText(localeInfo.NumberToDragonScaleString(player.GetCurrentOfflineShopDragonScale()))
		# self.wndDragonClaw.SetText(localeInfo.NumberToDragonClawString(player.GetCurrentOfflineShopDragonClaw()))
		self.Show()
		
	def OpenPickMoneyDialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(10)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT0)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawMoney))
		moneyDialog.Open(player.GetCurrentOfflineShopMoney())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawMoney(self, money):
		net.SendOfflineShopWithdrawMoney(money)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickChequeDialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(10)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_CHEQUE)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawCheque))
		moneyDialog.Open(player.GetCurrentOfflineShopCheque())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawCheque(self, cheque):
		net.SendOfflineShopWithdrawCheque(cheque)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickBar1Dialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(3)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_BAR1)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawBar1))
		moneyDialog.Open(player.GetCurrentOfflineShopBar1())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawBar1(self, bar):
		net.SendOfflineShopWithdrawBar1(bar)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickBar2Dialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(3)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_BAR2)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawBar2))
		moneyDialog.Open(player.GetCurrentOfflineShopBar2())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawBar2(self, bar):
		net.SendOfflineShopWithdrawBar2(bar)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickBar3Dialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(3)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_BAR3)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawBar3))
		moneyDialog.Open(player.GetCurrentOfflineShopBar3())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawBar3(self, bar):
		net.SendOfflineShopWithdrawBar3(bar)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickSoulStoneDialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(3)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_SOUL_STONE)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawSoulStone))
		moneyDialog.Open(player.GetCurrentOfflineShopSoulStone())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawSoulStone(self, st):
		net.SendOfflineShopWithdrawSoulStone(st)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickDragonScaleDialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(3)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_DRAGON_SCALE)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawDragonScale))
		moneyDialog.Open(player.GetCurrentOfflineShopDragonScale())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawDragonScale(self, ds):
		net.SendOfflineShopWithdrawDragonScale(ds)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OpenPickDragonClawDialog(self):
		moneyDialog = uiPickMoney.PickMoneyDialog2()
		moneyDialog.LoadDialog()
		moneyDialog.SetMax(3)
		moneyDialog.SetTitleName(localeInfo.MONETARY_UNIT_DRAGON_CLAW)
		moneyDialog.SetAcceptEvent(ui.__mem_func__(self.OnWithdrawDragonClaw))
		moneyDialog.Open(player.GetCurrentOfflineShopDragonClaw())
		self.moneyDialog = moneyDialog
		
	def OnWithdrawDragonClaw(self, dc):
		net.SendOfflineShopWithdrawDragonClaw(dc)
		net.SendRefreshOfflineShopMoney()
		self.withdrawMoneyTime = app.GetTime()
		
	def OnPressEscapeKey(self):
		self.Close()
		return True
		
	def OnPressExitKey(self):
		self.Close()
		return True
		
	def OnUpdate(self):
		# All time update.
		try:
			if (app.GetTime() < self.updateTime + 1):
				return
			
			self.updateTime = app.GetTime()
			net.SendRefreshOfflineShopMoney()
			self.wndMoney.SetText(localeInfo.NumberToMoneyString(player.GetCurrentOfflineShopMoney()))
			self.wndCheque.SetText(localeInfo.NumberToChequeString(player.GetCurrentOfflineShopCheque()))
			# self.wndBar1.SetText(localeInfo.NumberToBar1String(player.GetCurrentOfflineShopBar1()))
			# self.wndBar2.SetText(localeInfo.NumberToBar2String(player.GetCurrentOfflineShopBar2()))
			# self.wndBar3.SetText(localeInfo.NumberToBar3String(player.GetCurrentOfflineShopBar3()))
			# self.wndSoulStone.SetText(localeInfo.NumberToSoulStoneString(player.GetCurrentOfflineShopSoulStone()))
			# self.wndDragonScale.SetText(localeInfo.NumberToDragonScaleString(player.GetCurrentOfflineShopDragonScale()))
			# self.wndDragonClaw.SetText(localeInfo.NumberToDragonClawString(player.GetCurrentOfflineShopDragonClaw()))
		except:
			pass
				
###################################################################################################
## Offline Shop
class OfflineShopDialog(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.tooltipItem = 0
		self.xShopStart = 0
		self.yShopStart = 0
		self.questionDialog = None
		self.popup = None
		self.itemBuyQuestionDialog = None
		
	def __del__(self):
		ui.ScriptWindow.__del__(self)
		
	def Refresh(self):
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			itemCount = shop.GetOfflineShopItemCount(i)
			if (itemCount <= 1):
				itemCount = 0
			self.itemSlotWindow.SetItemSlot(i, shop.GetOfflineShopItemID(i), itemCount)
			
		for i in xrange(shop.OFFLINE_SHOP_SLOT_COUNT):
			vnum = shop.GetOfflineShopItemVnum(i)
			item.SelectItem(vnum)
			(itemWidth, itemHeight) = item.GetItemSize()
			if shop.GetOfflineShopItemStatus(i) == 2:
				if itemHeight == 1:
					self.itemSlotWindow.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/pattern/negative_frame1.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlotWindow.EnableSlot(i)
				elif itemHeight == 2:
					self.itemSlotWindow.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/pattern/negative_frame2.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlotWindow.EnableSlot(i)
				elif itemHeight == 3:
					self.itemSlotWindow.SetCoverButton(i, "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/pattern/negative_frame3.tga", "d:/ymir work/ui/public/slot_cover_button_04.sub", 1, 0)
					self.itemSlotWindow.EnableSlot(i)
			else:
				self.itemSlotWindow.SetCoverButton(i, "d:/ymir work/ui/game/quest/slot_button_01.sub","d:/ymir work/ui/game/quest/slot_button_01.sub","d:/ymir work/ui/game/quest/slot_button_01.sub", "d:/ymir work/ui/pattern/slot_disable.tga", False, False)
				self.itemSlotWindow.EnableSlot(i)		
				
		self.wndDisplayedCount.SetText(localeInfo.NumberToDisplayedCount(shop.GetDisplayedCount()))
		wndMgr.RefreshSlot(self.itemSlotWindow.GetWindowHandle())
		
	def LoadDialog(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/OfflineShopDialog.py")
		except:
			import exception
			exception.Abort("OfflineShopDialog.LoadDialog.LoadObject")
			
		try:
			self.itemSlotWindow = self.GetChild("ItemSlot")
			# self.btnBuy = self.GetChild("BuyButton")
			self.titleBar = self.GetChild("TitleBar")
			self.titleName = self.GetChild("TitleName")
			self.wndDisplayedCount = self.GetChild("DisplayedCount")
		except:	
			import exception
			exception.Abort("OfflineShopDialog.LoadDialog.BindObject")			
			
		self.itemSlotWindow.SetSlotStyle(wndMgr.SLOT_STYLE_NONE)
		self.itemSlotWindow.SAFE_SetButtonEvent("LEFT", "EXIST", self.SelectItemSlot)
		self.itemSlotWindow.SAFE_SetButtonEvent("RIGHT", "EXIST", self.UnselectItemSlot)
		
		self.itemSlotWindow.SetOverInItemEvent(ui.__mem_func__(self.OverInItem))
		self.itemSlotWindow.SetOverOutItemEvent(ui.__mem_func__(self.OverOutItem))
		
		# self.btnBuy.SetToggleUpEvent(ui.__mem_func__(self.CancelShopping))
		# self.btnBuy.SetToggleDownEvent(ui.__mem_func__(self.OnBuy))
		
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.Close))			
			
	def Destroy(self):
		self.Close()
		self.ClearDictionary()
		
		self.tooltipItem = 0
		self.itemSlotWindow = 0
		# self.btnBuy = 0
		self.titleBar = 0
		self.questionDialog = None
		self.popup = None
		
	def Open(self, vid):
		self.Refresh()
		self.SetTop()
		self.Show()
		
		# Set Title Name
		self.titleName.SetText(chr.GetNameByVID(vid))		
		
		(self.xShopStart, self.yShopStart, z) = player.GetMainCharacterPosition()	
		
	def Close(self):
		if (self.itemBuyQuestionDialog):
			self.itemBuyQuestionDialog.Close()
			self.itemBuyQuestionDialog = None
			constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(0)
			
		if (self.questionDialog):	
			self.OnCloseQuestionDialog()
		
		shop.Close()
		net.SendOfflineShopEndPacket()
		self.CancelShopping()
		self.tooltipItem.HideToolTip()
		self.Hide()
		
	def OnPressEscapeKey(self):
		self.Close()
		return True
		
	def OnPressExitKey(self):
		self.Close()
		return True
		
	# def OnBuy(self):
		# chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OFFLINE_SHOP_WARNING1)
		# chat.AppendChat(chat.CHAT_TYPE_INFO, localeInfo.OFFLINE_SHOP_WARNING2)
		# app.SetCursor(app.BUY)
		
	def CancelShopping(self):
		# self.btnBuy.SetUp()
		app.SetCursor(app.NORMAL)
		
	def OnCloseQuestionDialog(self):
		if (not self.questionDialog):
			return
			
		self.questionDialog.Close()
		self.questionDialog = None
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(0)
		
	def UnselectItemSlot(self, selectedSlotPos):
		if (constInfo.GET_ITEM_QUESTION_DIALOG_STATUS() == 1):
			return
			
		if shop.GetOfflineShopItemStatus(selectedSlotPos) == 0:
			self.AskBuyItem(selectedSlotPos)
		else:
			pass
		
	def SelectItemSlot(self, selectedSlotPos):
		if (constInfo.GET_ITEM_QUESTION_DIALOG_STATUS() == 1):
			return
			
		isAttached = mouseModule.mouseController.isAttached()
		if (not isAttached):
			curCursorNum = app.GetCursor()
			if (app.BUY == curCursorNum):
				net.SendOfflineShopBuyPacket(selectedSlotPos)
			else:
				selectedItemID = shop.GetOfflineShopItemID(selectedSlotPos)
				itemCount = shop.GetOfflineShopItemCount(selectedSlotPos)
				
				type = player.SLOT_TYPE_OFFLINE_SHOP
				mouseModule.mouseController.AttachObject(self, type, selectedSlotPos, selectedItemID, itemCount)
				mouseModule.mouseController.SetCallBack("INVENTORY", ui.__mem_func__(self.DropToInventory))
				snd.PlaySound("sound/ui/pick.wav")

	def DropToInventory(self):
		attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
		self.AskBuyItem(attachedSlotPos)

	def AskBuyItem(self, slotPos):
		itemIndex = shop.GetOfflineShopItemID(slotPos)
		itemPrice = shop.GetOfflineShopItemPrice(slotPos)
		itemPrice2 = shop.GetOfflineShopItemPrice2(slotPos)
		itemPriceType = shop.GetOfflineShopItemPriceType(slotPos)
		itemCount = shop.GetOfflineShopItemCount(slotPos)

		item.SelectItem(itemIndex)
		itemName = item.GetItemName()

		if itemPrice2 > 0:
			itemBuyQuestionDialog = uiCommon.QuestionDialog2()
			itemBuyQuestionDialog.SetText1(localeInfo.DO_YOU_BUY_ITEM(itemName, itemCount, localeInfo.NumberToMoneyString(itemPrice)))
			itemBuyQuestionDialog.SetText2(localeInfo.DO_YOU_BUY_ITEM_EX(itemPrice2, itemPriceType))
		else:
			itemBuyQuestionDialog = uiCommon.QuestionDialog()
			itemBuyQuestionDialog.SetText(localeInfo.DO_YOU_BUY_ITEM(itemName, itemCount, localeInfo.NumberToMoneyString(itemPrice)))			
		itemBuyQuestionDialog.SetAcceptEvent(lambda arg=True: self.AnswerBuyItem(arg))
		itemBuyQuestionDialog.SetCancelEvent(lambda arg=False: self.AnswerBuyItem(arg))
		itemBuyQuestionDialog.Open()
		itemBuyQuestionDialog.pos = slotPos
		self.itemBuyQuestionDialog = itemBuyQuestionDialog
		
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(1)
		
	def AnswerBuyItem(self, flag):
		if (flag):
			pos = self.itemBuyQuestionDialog.pos
			net.SendOfflineShopBuyPacket(pos)

		self.itemBuyQuestionDialog.Close()
		self.itemBuyQuestionDialog = None
		
		constInfo.SET_ITEM_QUESTION_DIALOG_STATUS(0)		
		
	def SetItemToolTip(self, tooltipItem):
		self.tooltipItem = tooltipItem
		
	def OverInItem(self, slotIndex):
		if (mouseModule.mouseController.isAttached()):
			return
			
		if (self.tooltipItem != 0):
			self.tooltipItem.SetOfflineShopItem(slotIndex)
			
	def OverOutItem(self):
		if (self.tooltipItem != 0):
			self.tooltipItem.HideToolTip()
		
	def OnUpdate(self):
		USE_SHOP_LIMIT_RANGE = 1500
		(x, y, z) = player.GetMainCharacterPosition()
		if abs(x - self.xShopStart) > USE_SHOP_LIMIT_RANGE or abs(y - self.yShopStart) > USE_SHOP_LIMIT_RANGE:
			self.Close()
			
