import ui
import player
import net
import constInfo
import wndMgr

# If your max-value is higher than 90, edit this:
maxvalue = 90

class StatusUp(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.editLineDict = {}
		self.__LoadWindow()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def OnPressEscapeKey(self):
		self.Hide()
		return True

	def Destroy(self):
		self.ClearDictionary()

	def __LoadWindow(self):
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "StatusUpWindow.py")
		except:
			import exception
			exception.Abort("StatusUpWindow.LoadWindow.LoadObject")

		try:
			self.StatusUpBoard = self.GetChild("board")
			self.GetChild("TitleBar").SetCloseEvent(ui.__mem_func__(self.Hide))
			self.hthvalue = self.GetChild("HTH_Value")
			self.hthgauge = self.GetChild("gauge_hth")
			self.hthadd = self.GetChild("HTH_Add")
			self.hthadd.SetNumberMode()
			self.hthadd.SetText("0")
			self.editLineDict["con"] = self.hthadd
			self.GetChild("HTH_Plus").SetEvent(lambda stat="con": self.AddStat(stat))
			self.intvalue = self.GetChild("INT_Value")
			self.intgauge = self.GetChild("gauge_int")
			self.intadd = self.GetChild("INT_Add")
			self.intadd.SetNumberMode()
			self.intadd.SetText("0")
			self.editLineDict["int"] = self.intadd
			self.GetChild("INT_Plus").SetEvent(lambda stat="int": self.AddStat(stat))
			self.strvalue = self.GetChild("STR_Value")
			self.strgauge = self.GetChild("gauge_str")
			self.stradd = self.GetChild("STR_Add")
			self.stradd.SetNumberMode()
			self.stradd.SetText("0")
			self.editLineDict["str"] = self.stradd
			self.GetChild("STR_Plus").SetEvent(lambda stat="str": self.AddStat(stat))
			self.dexvalue = self.GetChild("DEX_Value")
			self.dexgauge = self.GetChild("gauge_dex")
			self.dexadd = self.GetChild("DEX_Add")
			self.dexadd.SetNumberMode()
			self.dexadd.SetText("0")
			self.editLineDict["dex"] = self.dexadd
			self.GetChild("DEX_Plus").SetEvent(lambda stat="dex": self.AddStat(stat))
		except:
			import exception
			exception.Abort("StatusUpWindow.LoadWindow.BindObject")

	def OnUpdate(self):
		global maxvalue
		ht = player.GetStatus(player.HT)
		iq = player.GetStatus(player.IQ)
		st = player.GetStatus(player.ST)
		dx = player.GetStatus(player.DX)
		self.hthvalue.SetText("%s/%s" % (str(ht), str(maxvalue)))	# Vitalität
		self.hthgauge.SetPercentage(ht, maxvalue)
		self.intvalue.SetText("%s/%s" % (str(iq), str(maxvalue)))	# Intelligenz
		self.intgauge.SetPercentage(iq, maxvalue)
		self.strvalue.SetText("%s/%s" % (str(st), str(maxvalue)))	# Stärke
		self.strgauge.SetPercentage(st, maxvalue)
		self.dexvalue.SetText("%s/%s" % (str(dx), str(maxvalue)))	# Beweglichkeit
		self.dexgauge.SetPercentage(dx, maxvalue)

	def AddStat(self, stat):
		points = int(self.editLineDict[stat].GetText())
		net.SendChatPacket("/%s+ %s" % (str(stat), str(points)))
		#net.SendChatPacket("/stat %s %s" % (str(stat), str(points)))
