import net
import app
import ui
import uiOption
import uiSystemOption
import uiGameOption
import uiScriptLocale
import networkModule
import constInfo
import localeInfo
import dbg
import introLogin
import serverInfo
import uiCommon
import uiChangeChannel
import player
import constInfo
if app.ENABLE_TICKET_SYSTEM:
	import ticket
	import uiticket

SYSTEM_MENU_FOR_PORTAL = FALSE
log = dbg.LogBox

###################################################################################################
## System
class SystemDialog(ui.ScriptWindow):

	def __init__(self, stream):
		ui.ScriptWindow.__init__(self)
		self.__Initialize()
		self.stream = stream
	
	def __Initialize(self):
		self.eventOpenHelpWindow = None
		self.systemOptionDlg = None
		self.gameOptionDlg = None
		self.changeChDlg = None
		
		
	def LoadDialog(self):	
		if SYSTEM_MENU_FOR_PORTAL:
			self.__LoadSystemMenu_ForPortal()
		else:
			self.__LoadSystemMenu_Default()
			
	def __LoadSystemMenu_Default(self):
		pyScrLoader = ui.PythonScriptLoader()
		if constInfo.IN_GAME_SHOP_ENABLE:
			pyScrLoader.LoadScriptFile(self, uiScriptLocale.LOCALE_UISCRIPT_PATH + "SystemDialog.py")
		else:
			pyScrLoader.LoadScriptFile(self, "uiscript/systemdialog.py")

		self.GetChild("system_option_button").SAFE_SetEvent(self.__ClickSystemOptionButton)
		self.GetChild("game_option_button").SAFE_SetEvent(self.__ClickGameOptionButton)
		self.GetChild("change_button").SAFE_SetEvent(self.__ClickChangeCharacterButton)
		self.GetChild("logout_button").SAFE_SetEvent(self.__ClickLogOutButton)
		self.GetChild("exit_button").SAFE_SetEvent(self.__ClickExitButton)
		#self.GetChild("help_button").SAFE_SetEvent(self.__ClickHelpButton)
		self.GetChild("cancel_button").SAFE_SetEvent(self.Close)
		#self.GetChild("channel_change").SAFE_SetEvent(self.__ClickChangeChannelButton)
		# self.GetChild("switch_button").SAFE_SetEvent(self.__ClickSwitchButton)
		self.GetChild("arayuz_button").SAFE_SetEvent(self.arayuz)
		# if app.ENABLE_TICKET_SYSTEM:
			# self.GetChild("open_support").SAFE_SetEvent(self.__ClickOpenSupportButton)

		for i in xrange(4):
			self.GetChild("ch%d_button" % (i + 1)).SAFE_SetEvent(self.__ChannelSwitch, (i + 1))
		
		if constInfo.IN_GAME_SHOP_ENABLE:
			self.GetChild("mall_button").SAFE_SetEvent(self.__ClickInGameShopButton)	
			self.GetChild("GokmenCikis").SAFE_SetEvent(self.__GokmenGidiyor)

	def __LoadSystemMenu_ForPortal(self):
		pyScrLoader = ui.PythonScriptLoader()
		pyScrLoader.LoadScriptFile(self, "uiscript/systemdialog_forportal.py")
		
		self.GetChild("system_option_button").SAFE_SetEvent(self.__ClickSystemOptionButton)
		self.GetChild("game_option_button").SAFE_SetEvent(self.__ClickGameOptionButton)
		self.GetChild("change_button").SAFE_SetEvent(self.__ClickChangeCharacterButton)
		self.GetChild("exit_button").SAFE_SetEvent(self.__ClickExitButton)
		#self.GetChild("help_button").SAFE_SetEvent(self.__ClickHelpButton)
		self.GetChild("cancel_button").SAFE_SetEvent(self.Close)
		

	def Destroy(self):
		self.ClearDictionary()
		
		if self.gameOptionDlg:
			self.gameOptionDlg.Destroy()
			
		if self.systemOptionDlg:
			self.systemOptionDlg.Destroy()
			
		if self.changeChDlg:
			self.changeChDlg.Destroy()			
			
		self.__Initialize()

	def SetOpenHelpWindowEvent(self, event):
		self.eventOpenHelpWindow = event

	def OpenDialog(self):
		self.Show()

	def __ClickChangeCharacterButton(self):
		self.Close()

		net.ExitGame()

	def __OnClosePopupDialog(self):
		self.popup = None		

	def __ClickLogOutButton(self):
		if SYSTEM_MENU_FOR_PORTAL: 
			if app.loggined:
				self.Close()
				net.ExitApplication()
			else:
				self.Close()
				net.LogOutGame()
		else:
			self.Close()
			net.LogOutGame()


	def __ClickExitButton(self):
		self.Close()
		net.ExitApplication()
	
	if app.ENABLE_TICKET_SYSTEM:
		def __ClickOpenSupportButton(self):
			self.Close()
			ticket.SendTicketPacketOpen(1, 0, "")	
		
	def __ClickSystemOptionButton(self):
		self.Close()

		if not self.systemOptionDlg:
			self.systemOptionDlg = uiSystemOption.OptionDialog()

		self.systemOptionDlg.Show()

	def __ClickGameOptionButton(self):
		self.Close()

		if not self.gameOptionDlg:
			self.gameOptionDlg = uiGameOption.OptionDialog()

		self.gameOptionDlg.Show()

	
	def __ClickInGameShopButton(self):	 
	   	self.Close()
		net.SendChatPacket("/in_game_mall")
		
	# def __ClickSwitchButton(self):
		# self.Close()
		# self.EfsunBotDialog = uiCommon.QuestionDialogEfsun()
		# self.EfsunBotDialog.SetText("Hangi efsun botunu kullanmak istiyorsunuz?")
		# self.EfsunBotDialog.SetAcceptText("Normal Efsun Nesnesi")
		# self.EfsunBotDialog.SetCancelText("Yesil Efsun Nesnesi")
		# self.EfsunBotDialog.SetAcceptEvent(lambda arg=TRUE: self.OnEfsunBotDialog(1))
		# self.EfsunBotDialog.SetCancelEvent(lambda arg=FALSE: self.OnEfsunBotDialog(2))
		# self.EfsunBotDialog.Open()

	def arayuz(self):
		self.Close()
		try:
			self.k.OpenDialog()
			pass
		except:
			import uiinterfececolor
			self.k = uiinterfececolor.kolorDialog()
			self.k.OpenDialog()
			pass	
		
	def OnEfsunBotDialog(self,gelen):
		self.EfsunBotDialog.Close()
		if gelen==1:
			import officialfilesgame
			if not constInfo.eigenmod:
				execfile('eigenmods.py',{})
				constInfo.eigenmod = 1
			else:
				chat.AppendChat(1, constInfo.sarirenk+officialfilesgame.EFSUNBOTAKTIF)
		else:
			import officialfilesgame
			if not constInfo.eigenmod:
				execfile('eigenmods1.py',{})
				constInfo.eigenmod = 1
			else:
				chat.AppendChat(1, constInfo.sarirenk+officialfilesgame.EFSUNBOTAKTIF)
			
			# pyScrLoader = ui.PythonScriptLoader()
			# pyScrLoader.LoadScriptFile(self, "efsunbot.pyc")
		# else:
			# import officialfilesgame
			# if not constInfo.eigenmod:
				# execfile('eigenmods.py',{})
				# constInfo.eigenmod = 1
			# else:
				# chat.AppendChat(1, constInfo.sarirenk+officialfilesgame.EFSUNBOTAKTIF)

	def __GokmenGidiyor(self):
	   	import app
	   	app.Exit()

	def Close(self):
		self.Hide()
		return TRUE

	def RefreshMobile(self):
		if self.gameOptionDlg:
			self.gameOptionDlg.RefreshMobile()
		#self.optionDialog.RefreshMobile()

	def OnMobileAuthority(self):
		if self.gameOptionDlg:
			self.gameOptionDlg.OnMobileAuthority()
		#self.optionDialog.OnMobileAuthority()

	def OnBlockMode(self, mode):
		uiGameOption.blockMode = mode
		if self.gameOptionDlg:
			self.gameOptionDlg.OnBlockMode(mode)
		#self.optionDialog.OnBlockMode(mode)

	def OnChangePKMode(self):
		if self.gameOptionDlg:
			self.gameOptionDlg.OnChangePKMode()
		#self.optionDialog.OnChangePKMode()
		
	# def __ClickChangeChannelButton(self):
		# self.Close()


		# if not self.changeChDlg:
			# self.changeChDlg = uiChangeChannel.uiChangeChannel(self.stream)


		# self.changeChDlg.Show()
	
	def __ChannelSwitch(self, flag):
		net.SendChatPacket("/channel " + str(flag))
		self.Close()
	
	def OnPressExitKey(self):
		self.Close()
		return TRUE

	def OnPressEscapeKey(self):
		self.Close()
		return TRUE

if __name__ == "__main__":

	import app
	import wndMgr
	import systemSetting
	import mouseModule
	import grp
	import ui
	import chr
	import background
	import player

	#wndMgr.SetOutlineFlag(TRUE)

	app.SetMouseHandler(mouseModule.mouseController)
	app.SetHairColorEnable(TRUE)
	wndMgr.SetMouseHandler(mouseModule.mouseController)
	wndMgr.SetScreenSize(systemSetting.GetWidth(), systemSetting.GetHeight())
	app.Create("METIN2 CLOSED BETA", systemSetting.GetWidth(), systemSetting.GetHeight(), 1)
	mouseModule.mouseController.Create()


	wnd = SystemDialog()
	wnd.LoadDialog()
	wnd.Show()

	app.Loop()

