import ui
import net
import grp
import snd
import item
import chat
import player
import localeInfo
import constInfo
import uiToolTip
import mouseModule
import uiScriptLocale
import uiinventory

class TransferWindow(ui.ScriptWindow):
	def __init__(self):
		import exception
		ui.ScriptWindow.__init__(self)
		self.slot_pos_index = 999
		self.slot_index1 = 999
		self.slot_index2 = 999
		self.slot_index3 = 999
		self.isLoaded = 0
		self.tooltipItem = uiToolTip.ItemToolTip()
		self.tooltipItem.Hide()

		self.LoadWindow()

	def __del__(self):
		ui.ScriptWindow.__del__(self)

	def LoadWindow(self):
		if self.isLoaded == 1:
			return
		
		self.isLoaded = 1
		
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "UIScript/item.py")
			
		except:
			import exception
			exception.Abort("TransferWindow.LoadDialog.LoadScript")
			
		try:
			GetObject=self.GetChild
			self.titleBar = GetObject("TitleBar")
			self.btnCancel = GetObject("CancelButton")
			self.btnAccept = GetObject("AcceptButton")
			self.startslot = GetObject("MediumSlot")
			self.combslot = GetObject("CombSlot")
		except:
			import exception
			exception.Abort("TransferWindow.LoadDialog.BindObject")
		self.titleBar.SetCloseEvent(ui.__mem_func__(self.__OnCloseButtonClick))
		self.btnCancel.SetEvent(ui.__mem_func__(self.__OnCloseButtonClick))
		self.btnAccept.SetEvent(ui.__mem_func__(self.__OnAcceptButtonClick))
		self.combslot.SetSelectEmptySlotEvent(ui.__mem_func__(self.__OnSelectEmptySlot))
		self.combslot.SetSelectItemSlotEvent(ui.__mem_func__(self.__OnSelectItemSlot))
		self.combslot.SetOverInItemEvent(ui.__mem_func__(self.__OnOverInItem))
		self.combslot.SetOverOutItemEvent(ui.__mem_func__(self.__OnOverOutItem))
		self.startslot.SetOverInItemEvent(ui.__mem_func__(self.__OnOverInItem))
		self.startslot.SetOverOutItemEvent(ui.__mem_func__(self.__OnOverOutItem))
		self.startslot.SetSelectEmptySlotEvent(ui.__mem_func__(self.__OnSelectEmptySlot1))
		self.startslot.SetSelectItemSlotEvent(ui.__mem_func__(self.__OnSelectItemSlot1))
		self.combItemInfo = {}
		self.tooltipItem = None
		self.firstSlotIndex = 0

	def SetItemToolTip(self, itemTooltip):
		self.tooltipItem = itemTooltip
		
	def Destroy(self):
		self.ClearDictionary()
		self.titleBar = None
		self.btnAccept = None
		self.btnCancel = None
		self.combslot = None
		self.startslot = None
		self.tooltipItem = None
		self.slot_pos_index = None
		self.slot_index1 = None
		self.slot_index2 = None
		self.slot_index3 = None
		
	def __OnCloseButtonClick(self):		
		self.Close()

	def __OnAcceptButtonClick(self):		
		if self.combItemInfo.has_key(0):
			if self.combItemInfo.has_key(1):
				if self.combItemInfo.has_key(2):
					net.SendChatPacket("/bonus_costume_transfer %d %d %d" % (self.combItemInfo[1],self.combItemInfo[2],self.combItemInfo[0]))
					self.Clear()
		return
	def Close(self):
		if self.tooltipItem:
			self.tooltipItem.HideToolTip()

		self.Hide()
		
	def Clear(self):
		self.slot_index1 = 999
		self.slot_index2 = 999
		self.slot_index3 = 999
		self.combslot.ClearSlot(1)
		self.combslot.ClearSlot(2)
		self.combslot.ClearSlot(3)
		self.startslot.ClearSlot(0)
		del self.combItemInfo[0]
		del self.combItemInfo[1]
		del self.combItemInfo[2]				

	def Open(self):
		self.LoadWindow()
		ui.ScriptWindow.Show(self)
		self.combItemInfo = {}
		self.slot_index1 = 999
		self.slot_index2 = 999
		self.startslot.ClearSlot(0)
		self.combslot.ClearSlot(1)
		self.combslot.ClearSlot(2)
		self.combslot.ClearSlot(3)
		self.tooltipItem = uiToolTip.ItemToolTip()
		self.tooltipItem.Hide()

	def Refresh(self):
		pass
		
	def __OnSelectEmptySlot(self, selectedSlotPos):
		if selectedSlotPos == 3:
			return
		isAttached = mouseModule.mouseController.isAttached()
		if isAttached:
			attachedSlotType = mouseModule.mouseController.GetAttachedType()
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			mouseModule.mouseController.DeattachObject()
			if player.SLOT_TYPE_INVENTORY != attachedSlotType:
				return
			if selectedSlotPos == 3 and self.slot_pos_index == 999:
				return
				
			if self.slot_index1 == attachedSlotPos and selectedSlotPos == 1 or self.slot_index2 == attachedSlotPos and selectedSlotPos == 2:
				return
			elif self.slot_index2 == attachedSlotPos and selectedSlotPos == 1 or self.slot_index1 == attachedSlotPos and selectedSlotPos == 2:
				return
				
			if selectedSlotPos == 1:
				self.slot_index1 = attachedSlotPos
			elif selectedSlotPos == 2:
				self.slot_index2 = attachedSlotPos
			for slotPos, invenPos in self.combItemInfo.items():
				if invenPos == attachedSlotPos:
					del self.combItemInfo[slotPos]
				
			self.combItemInfo[selectedSlotPos] = attachedSlotPos
			chat.AppendChat(chat.CHAT_TYPE_INFO, "%d %d" % (selectedSlotPos,attachedSlotPos))
			self.slot_pos_index = attachedSlotPos
			self.combslot.ClearSlot(selectedSlotPos)
			self.combslot.SetItemSlot(selectedSlotPos, player.GetItemIndex(attachedSlotPos), player.GetItemCount(attachedSlotPos))
		
			self.Refresh()

	def __OnSelectItemSlot(self, selectedSlotPos):
		if selectedSlotPos == 3:
			return
		
		snd.PlaySound("sound/ui/loginfail.wav")
		self.combslot.ClearSlot(selectedSlotPos)
		
		if not selectedSlotPos in self.combItemInfo:
			return
		
		del self.combItemInfo[selectedSlotPos]
		
		isAttached = mouseModule.mouseController.isAttached()
		if isAttached:
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			if selectedSlotPos == 3:
				return
				
			if selectedSlotPos == 1:
				self.slot_pos_index = attachedSlotPos
				
			if self.slot_index1 == attachedSlotPos and selectedSlotPos == 1 or self.slot_index2 == attachedSlotPos and selectedSlotPos == 2:
				return
			elif self.slot_index2 == attachedSlotPos and selectedSlotPos == 1 or self.slot_index1 == attachedSlotPos and selectedSlotPos == 2:
				return
				
			if selectedSlotPos == 1:
				self.slot_index1 = attachedSlotPos
			elif selectedSlotPos == 2:
				self.slot_index2 = attachedSlotPos
				
			for slotPos, invenPos in self.combItemInfo.items():
				if invenPos == attachedSlotPos:
					del self.combItemInfo[slotPos]
				
			self.combItemInfo[selectedSlotPos] = attachedSlotPos
			chat.AppendChat(chat.CHAT_TYPE_INFO, "%d %d" % (selectedSlotPos,attachedSlotPos))
			self.combslot.ClearSlot(selectedSlotPos)
			self.combslot.SetItemSlot(selectedSlotPos, player.GetItemIndex(attachedSlotPos), player.GetItemCount(attachedSlotPos))
		
			mouseModule.mouseController.DeattachObject()
		
		self.Refresh()

	def __OnSelectEmptySlot1(self, selectedSlotPos):
		isAttached = mouseModule.mouseController.isAttached()
		if isAttached:
			attachedSlotType = mouseModule.mouseController.GetAttachedType()
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			mouseModule.mouseController.DeattachObject()
			if player.SLOT_TYPE_INVENTORY != attachedSlotType:
				return
			self.slot_index3 = attachedSlotPos
			for slotPos, invenPos in self.combItemInfo.items():
				if invenPos == attachedSlotPos:
					del self.combItemInfo[selectedSlotPos]
				
			self.combItemInfo[selectedSlotPos] = attachedSlotPos
			chat.AppendChat(chat.CHAT_TYPE_INFO, "%d %d" % (selectedSlotPos,attachedSlotPos))
			self.slot_pos_index = attachedSlotPos
			self.startslot.ClearSlot(selectedSlotPos)
			self.startslot.SetItemSlot(selectedSlotPos, player.GetItemIndex(attachedSlotPos), player.GetItemCount(attachedSlotPos))
		
			self.Refresh()

	def __OnSelectItemSlot1(self, selectedSlotPos):

		snd.PlaySound("sound/ui/loginfail.wav")
		self.startslot.ClearSlot(selectedSlotPos)

		del self.combItemInfo[selectedSlotPos]
		
		isAttached = mouseModule.mouseController.isAttached()
		if isAttached:
			attachedSlotType = mouseModule.mouseController.GetAttachedType()
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			if player.SLOT_TYPE_INVENTORY != attachedSlotType:
				return
			for slotPos, invenPos in self.combItemInfo.items():
				if invenPos == attachedSlotPos:
					del self.combItemInfo[selectedSlotPos]
				
			self.combItemInfo[selectedSlotPos] = attachedSlotPos
			chat.AppendChat(chat.CHAT_TYPE_INFO, "%d %d" % (selectedSlotPos,attachedSlotPos))
			self.startslot.ClearSlot(selectedSlotPos)
			self.startslot.SetItemSlot(selectedSlotPos, player.GetItemIndex(attachedSlotPos), player.GetItemCount(attachedSlotPos))
		
			mouseModule.mouseController.DeattachObject()
		
		self.Refresh()
		
	def __OnOverInItem(self, slotIndex):
		if slotIndex == 3:
			itemVnum = player.GetItemIndex(self.slot_index1)
			self.tooltipItem.SetItemToolTip(itemVnum)
			self.tooltipItem.SetInventoryItem(self.combItemInfo[1],player.INVENTORY,istransfer=1)
			item.SelectItem(player.GetItemIndex(self.slot_index1))			
			attrSlot = []
			for w in xrange(player.ATTRIBUTE_SLOT_MAX_NUM):
				attrSlot.append(player.GetItemAttribute(self.slot_index2, w))
				
			if 0 != attrSlot:
				for q in xrange(player.ATTRIBUTE_SLOT_MAX_NUM):
					if q >= 7:
						continue
					else:
						type = attrSlot[q][0]
						value = attrSlot[q][1]
						if 0 == value:
							continue
							
						value = value
							
						if value <= 0:
							if type != 0:
								value = 1
							else:
								value = 0
							
						affectString = self.GetAffectString(type, value)
						if affectString:
							affectColor = self.GetAttributeColor(q, value)
							self.tooltipItem.AppendTextLine(affectString, affectColor)
			return
		if self.tooltipItem:
			if self.combItemInfo.has_key(slotIndex):
				self.tooltipItem.SetInventoryItem(self.combItemInfo[slotIndex])

	def __OnOverOutItem(self):
		if self.tooltipItem:
			self.tooltipItem.HideToolTip()
			
	def OnUpdate(self):
		if self.combItemInfo.has_key(0):
			if self.combItemInfo.has_key(1):
				if self.combItemInfo.has_key(2):
					self.combslot.ClearSlot(3)
					self.combslot.SetItemSlot(3, player.GetItemIndex(self.combItemInfo[1]), 1)
					
	def GetAffectString(self, affectType, affectValue):
		if 0 == affectType:
			return None

		if 0 == affectValue:
			return None

		try:
			return self.tooltipItem.AFFECT_DICT[affectType](affectValue)
		except TypeError:
			return "UNKNOWN_VALUE[%s] %s" % (affectType, affectValue)
		except KeyError:
			return "UNKNOWN_TYPE[%s] %s" % (affectType, affectValue)

	def GetAttributeColor(self, index, value):
		if value > 0:
			if index >= 5 and index <= 6:
				return self.tooltipItem.SPECIAL_POSITIVE_COLOR2
			elif index >= 7:
				return self.tooltipItem.POSITIVE_COLOR
			else:
				return self.tooltipItem.SPECIAL_POSITIVE_COLOR
		elif value == 0:
			return self.tooltipItem.SPECIAL_POSITIVE_COLOR
		else:
			return self.tooltipItem.NEGATIVE_COLOR

	def GetChangeTextLineColor(self, value, isSpecial=FALSE):
		if value > 0:
			if isSpecial:
				return self.tooltipItem.SPECIAL_POSITIVE_COLOR2
			else:
				return self.tooltipItem.POSITIVE_COLOR
		
		if 0 == value:
			return self.tooltipItem.SPECIAL_POSITIVE_COLOR
		
		return self.tooltipItem.NEGATIVE_COLOR

