import ui
import mouseModule
import player
import net
import snd
import safebox
import chat
import app
import localeInfo
import uiScriptLocale
import item
import shop
import uiCommon
import translate

class Yansitma(ui.ScriptWindow):
	def __init__(self):
		ui.ScriptWindow.__init__(self)
		self.arryfeed = [-1, -1]
		self.__LoadDialog()
		self.sendMessage = "/yansitl %d %d"
		self.questionDialog = None

	def __del__(self):
		ui.ScriptWindow.__del__(self)
	def __LoadDialog(self):
		self.uyari2 = uiCommon.PopupDialog()
		try:
			pyScrLoader = ui.PythonScriptLoader()
			pyScrLoader.LoadScriptFile(self, "uiscript/changelookwindow.py")
		except:
			import exception
			exception.Abort("Yansitma.__LoadDialog")
		try:
			self.acceptButton = self.GetChild("AcceptButton")
			self.CancelButton = self.GetChild("CancelButton")
			self.titleName = self.GetChild("TitleName")
			self.text1 = self.GetChild("Cost")
			itemslot = self.GetChild("ChangeLookSlot")
			itemslot.SetOverInItemEvent(ui.__mem_func__(self.OverInItem))
			itemslot.SetOverOutItemEvent(ui.__mem_func__(self.OverOutItem))
			itemslot.SetSelectEmptySlotEvent(ui.__mem_func__(self.SelectEmptySlot))
			itemslot.SetUnselectItemSlotEvent(ui.__mem_func__(self.SelectItemSlot))
			itemslot.SetUseSlotEvent(ui.__mem_func__(self.SelectItemSlot))
			itemslot.SAFE_SetButtonEvent("RIGHT", "EXIST", self.SelectItemSlot)
			self.itemslot = itemslot
			self.GetChild("TitleBar").SetCloseEvent(ui.__mem_func__(self.CloseDialog))
		except:
			import exception
			exception.Abort("Yansitma.__LoadDialog")

		self.text1.SetText(translate.costfi)
		self.titleName.SetText(translate.yansitma_baslik)
		self.acceptButton.SetEvent(ui.__mem_func__(self.OnAccept))
		self.CancelButton.SetEvent(ui.__mem_func__(self.CloseDialog))

	def SetItemToolTip(self, tooltipItem):
		self.tooltipItem = tooltipItem
	def SelectItemSlot(self, itemSlotIndex):
		self.arryfeed[itemSlotIndex] = -1
		self.itemslot.ClearSlot(itemSlotIndex)
		self.itemslot.RefreshSlot()

	def OverInItem(self, slotIndex):
		if self.tooltipItem:
			if self.arryfeed[slotIndex] != -1:
				self.tooltipItem.SetInventoryItem(self.arryfeed[slotIndex])

	def OverOutItem(self):
		if self.tooltipItem:
			self.tooltipItem.HideToolTip()
	def SelectEmptySlot(self, pos):
		if mouseModule.mouseController.isAttached():
			attachedSlotType = mouseModule.mouseController.GetAttachedType()
			attachedSlotPos = mouseModule.mouseController.GetAttachedSlotNumber()
			mouseModule.mouseController.DeattachObject()
			if player.IsEquipmentSlot(attachedSlotPos):
				return
			if player.SLOT_TYPE_INVENTORY == attachedSlotType:
				if int(attachedSlotPos) < 225 and (not attachedSlotPos in self.arryfeed) and self.arryfeed[pos] == -1:
					dstItemVNum = player.GetItemIndex(attachedSlotPos)
					item.SelectItem(dstItemVNum)					
					if not item.GetItemType() in (item.ITEM_TYPE_WEAPON, item.ITEM_TYPE_ARMOR):	 
						return
					if item.GetItemType() == item.ITEM_TYPE_ARMOR:
						if item.GetItemSubType() != item.ARMOR_BODY:
							return
					attrSlot = [player.GetItemAttribute(attachedSlotPos, i) for i in xrange(player.ATTRIBUTE_SLOT_MAX_NUM)]
					if attrSlot[6][0] == 1:
						self.uyari2.SetText(translate.kilitlilanbu)
						self.uyari2.Open()
						return
					elif attrSlot[5][1] >= 10:
						self.uyari2.SetText(translate.zatenyansimis)
						self.uyari2.Open()
						return
					self.itemslot.SetItemSlot(int(pos), int(player.GetItemIndex(int(attachedSlotPos))), 0)
					self.arryfeed[pos] = attachedSlotPos

	def Destroy(self):
		self.ClearDictionary()
		self.item_value = None
		self.acceptButton = None
		self.CancelButton = None
		self.titleName = None
		if self.questionDialog:
			self.questionDialog.Close()
		self.questionDialog = None

	def ShowDialog(self):
		self.arryfeed[0] = -1
		self.arryfeed[1] = -1
		self.itemslot.ClearSlot(0)
		self.itemslot.ClearSlot(1)
		self.itemslot.RefreshSlot()
		self.SetCenterPosition()
		self.Show()
	def CloseDialog(self):
		self.arryfeed[0] = -1
		self.arryfeed[1] = -1
		self.itemslot.ClearSlot(0)
		self.itemslot.ClearSlot(1)
		self.itemslot.RefreshSlot()
		self.Hide()

	def OnAccept(self):
		item1=self.arryfeed[0]
		item2=self.arryfeed[1]
		if item1 == -1 or item2 == -1:
			self.uyari2.SetText(translate.itemyok)
			self.uyari2.Open()
			return False
		
		self.questionDialog = uiCommon.QuestionDialog()
		self.questionDialog.SetText(translate.yapakmila)
		self.questionDialog.SetAcceptEvent(ui.__mem_func__(self.Kabul))
		self.questionDialog.SetCancelEvent(ui.__mem_func__(self.OnCloseQuestionDialog))
		self.questionDialog.Open()
		return True

	def OnCloseQuestionDialog(self):
		if not self.questionDialog:
			return
		
		self.questionDialog.Close()
		self.questionDialog = None

	def Kabul(self):
		item1=self.arryfeed[0]
		item2=self.arryfeed[1]
		if item1 == -1 or item2 == -1:
			self.uyari2.SetText(translate.itemyok)
			self.uyari2.Open()
			return False
		self.OnCloseQuestionDialog()
		net.SendChatPacket(self.sendMessage % (int(item1),int(item2)))
		self.CloseDialog()
		
	def OnCancel(self):
		self.CloseDialog()
		return True
