<?php
	@ob_start();
	include 'include/functions/header.php';
?>
<!DOCTYPE html>
<html lang="<?php print $language_code; ?>">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title><?php print $site_title.' - '.$title; if($offline) print ' - '.$lang['server-offline']; ?></title>
    <meta http-equiv="X-UA-Compatible" content="IE=EmulateIE7" />
    <link rel="shortcut icon" href="favicon.ico" type="image/x-icon" />
    <link href="<?php print $site_url; ?>css/home.css" rel="stylesheet" type="text/css" />
    <link href="<?php print $site_url; ?>css/featherlight.css" rel="stylesheet" type="text/css" />
	<link href="<?php print $site_url; ?>css/font-awesome.min.css" rel="stylesheet">
	<link rel="stylesheet" href="<?php print $site_url; ?>css/bootstrap.css">
	<link rel="stylesheet" href="<?php print $site_url; ?>css/bootstrap-table.css">
	<?php if($page=="admin" && $a_page=="player_edit") { ?>
    <link rel='stylesheet' href='<?php print $site_url; ?>css/bootstrap-select.css'/>
	<?php } ?>
	<link rel="shortcut icon" href="<?php print $site_url; ?>images/favicon.ico?v=" />
	<style>
        .large:hover {
            height: <?php print 45*count($json_languages['languages']); ?>px;
        }
	</style>
</head>
<body>

    <ul class="languagepicker roundborders large">

	<?php
	print '<a href="javascript:void(0)"><li><img width="24" src="'.$site_url.'images/flags/'.$language_code.'.png"/></li></a>';
		foreach($json_languages['languages'] as $key => $value)
			if($key!=$language_code)
				print '<a href="'.$site_url.'?lang='.$key.'"><li><img width="24" src="'.$site_url.'images/flags/'.$key.'.png"/></li></a>';
	?>
					            

	</ul>
	<?php if(!$offline && $statistics) { ?>
	<div id="mmonetbar" class="mmometin2" style="display: block;">
			<script type="text/javascript">
			</script>
			<div id="mmoContent" class="mmosmallbar">


				<div id="mmoGame" class="mmoGame" style="display: block;">
							<?php
								foreach($jsondataFunctions as $key => $status)
									if(!in_array($key, array('active-registrations', 'players-debug', 'active-referrals')) && $status)
									{
							?>
							<div class="mmoBoxLeft"></div>
							<div class="mmoBoxMiddle">
								<div id="mmoOnline">
									<label><?php print $lang[$key].' : '.number_format(getStatistics($key), 0, '', '.'); ?></label>
								</div>
							</div>
							<div class="mmoBoxRight"></div>
							<div class="mmo-breadcrumb"></div>
							<?php
									}
							?>
				</div>
				<input id="mmoFocus" type="text" size="5">
			</div><!-- /mmoContent -->
		</div>
		<?php } ?>

		<?php
			if($item_shop!="")
				$shop_url = $item_shop;
			else if(is_dir('shop')) 
				$shop_url = $site_url.'shop'; 
			else $shop_url = ''; 
		?>
<?php
if($database->is_loggedin()) {
?>
   <header role="banner">
        <h1 class="logo"><?php echo $site_title; ?></h1>
        <div class="ui container loggedin">
                        <div class="userinfo">
                <div class="welcome-text-left">Welcome <?php print getAccountName($_SESSION['id']); ?></div>
                <div class="right"><?php print getAccountMD($_SESSION['id']).' '.$lang['md']; ?></div>
                <div class="center"><?php print getAccountJD($_SESSION['id']).' '.$lang['jd']; ?></div>
                <div class="header-box-nav-container">
                    <ul class="header-box-nav-login" style="margin-top: -5px;">
                        <li class="stepdown">
                            <a href="<?php print $site_url; ?>user/administration" class="nav-box-btn nav-box-btn-2"><?php print $lang['account-data']; ?></a>
                        </li>
                                                    <li class="stepdown">
                                <a target="_blank" href="<?php print $shop_url; ?>" class="nav-box-btn nav-box-btn-1">Item Shop</a>
                            </li>
                                                <li class="stepdown">
                            <a href="<?php print $site_url; ?>users/logout" class="nav-box-btn nav-box-btn-4"/><?php print $lang['logout']; ?></a>
                        </li>
                    </ul>
                </div>
            </div>
                                </div>
    </header>
	<iframe id="ishop" class="lightbox" src="<?php print $item_shop; ?>" >
	</iframe>
<?php
} else {
echo'
    <header role="banner">
        <h1 class="logo">'.$site_title.'</h1>
        <div class="ui container">
                        <a class="playfree" role="button" href="'.$site_url.'users/register">'.$lang['register'].'</a>
                                </div>
    </header>';
	}
	?>
    <div class="container">
        <div role="navigation">
            <nav>
                <ul>
					<li><a href="<?php print $site_url; ?>news"><?php print $lang['news']; ?></a></li>
					<?php if(!$database->is_loggedin()) { ?>
					<li><a href="<?php print $site_url; ?>download"><?php print $lang['download']; ?></a></li>
					<li><a href="<?php print $site_url; ?>users/login"><?php print $lang['login']; ?></a></li>
					<?php } else { ?>
                    <li><a href="<?php print $site_url; ?>user/administration" style="font-size: 12px;"><?php print $lang['account-data']; ?></a>
                        <ul>
							<?php if($web_admin) { ?>
							<li><a href="<?php print $site_url; ?>admin"><?php print $lang['administration']; ?></a></li>
							<?php 
								if($web_admin>=$jsondataPrivileges['donate']) {
									$count_donations = count(get_donations());
									if($count_donations)
									{
							?>	
							<li><a href="<?php print $site_url; ?>admin/donatelist"><?php print $lang['donatelist']; ?> <span class="tag tag-info tag-pill float-xs-right"><?php print $count_donations.' '.$lang['new-donations']; ?> </span></a></li>
							<?php
									}
								}
							}
							?>
							<li><a href="<?php print $site_url; ?>user/characters"><?php print $lang['chars-list']; ?></a></li>
							<li><a href="<?php print $site_url; ?>user/redeem"><?php print $lang['redeem-codes']; ?></a></li>
							<?php if($jsondataFunctions['active-referrals']) { ?>
							<li><a href="<?php print $site_url; ?>user/referrals"><?php print $lang['referrals']; ?></a></li>
							<?php } if($item_shop!="") { ?>
							<li><a target='_blank' href="<?php print $item_shop; ?>"><?php print $lang['item-shop']; ?></a></li>
							<?php }
								$vote4coins = file_get_contents('include/db/vote4coins.json');
								$vote4coins = json_decode($vote4coins, true);
								
								if(count($vote4coins))
									print '<li><a href="'.$site_url.'user/vote4coins">Vote4Coins</a></li>';
								
								$donate = file_get_contents('include/db/donate.json');
								$donate = json_decode($donate, true);
								
								if(count($donate))
									print '<li><a href="'.$site_url.'user/donate">'.$lang['donate'].'</a></li>';
							?>
							<li><a href="<?php print $site_url; ?>users/logout"><?php print $lang['logout']; ?></a></li>
                        </ul>
                    </li>
					<li><a href="<?php print $shop_url; ?>" target="_blank">Item Shop</a></li>
					<?php } ?>
					<li><a href="<?php print $forum; ?>" target="_blank">Forum</a></li>
					<li class="btn-download">
					<?php if(!$database->is_loggedin()) { ?>
						<a href="<?php print $site_url; ?>users/register"><?php print $lang['register']; ?></a>
					<?php } else { ?>
						<a href="<?php print $site_url; ?>download"><?php print $lang['download']; ?></a>
					<?php } ?>
					</li>
                    <li><a role="button" data-toggle="collapse" href="#collapseRanking" aria-expanded="false" aria-controls="collapseRanking"><?php print $lang['ranking']; ?></a>
						<ul class="collapse" id="collapseRanking">
                            <li><a href="<?php print $site_url; ?>ranking/players"><?php print $lang['players']; ?></a></li>
                            <li><a href="<?php print $site_url; ?>ranking/guilds"><?php print $lang['guilds']; ?></a></li>
                        </ul>
                    </li>
                </ul>
            </nav>
        </div>
		
		<div role="main">
			<?php
				include 'pages/'.$page.'.php';
			?>
		</div>
		<div class="secondary">
            <!-- side boxes -->
			<?php
			if(!($database->is_loggedin())) {
			?>
			<aside class="login" role="complementary">
                    <h2><?php print $lang['user-panel']; ?></h2>
                    <form action="<?php print $site_url; ?>users/login" method="post">
						<div class="form-login">
                            <label><?php print $lang['user-name']; ?></label>
                            <div class="input">
                                <input type="text" name="username" pattern=".{5,64}" maxlength="64" autocomplete="off" required/>
                            </div>
                            <label><?php print $lang['password']; ?></label>
                            <div class="input">
                                <input type="password" name="password" pattern=".{5,16}" maxlength="16" required/>
                            </div>
                            <div>
                                <input type="submit" class="button btn-login" type="submit"
                                name="SubmitLoginForm"
                                value="<?php print $lang['login']; ?>" />
                            </div>
							 <p class="agbok">
								<?php if(!$offline) { ?>
									<a href="<?php print $site_url; ?>users/lost" rel="nofollow" class="password"><?php print $lang['forget-password']; ?></a>
								<?php } ?>
						</p>
                        </div>
                    </form>
            </aside>

            <aside class="download" role="complementary">
                <h2><?php print $lang['download']; ?></h2>
                <a href="<?php print $site_url; ?>download" title="<?php print $lang['download']; ?>"></a>
            </aside>
			<?php 
				} else {
			?>
			<aside class="itemshop" role="complementary">
                <h2><center>Item-Shop</center></h2>
                <a href="<?php print $shop_url; ?>" target="_blank" class="itemshop btn itemshop-btn iframe" title="<?php print $lang['item-shop']; ?>"></a>
            </aside>
			<?php } ?>
            <aside class="highscore" role="complementary">
                <h2><?php print $lang['ranking']; ?></h2>
                <ul class="tabcontrols">
                    <li class="selected"><a href="#players"><img src="https://gf2.geo.gfsrv.net/cdna3/232b3d471340f1d6bed8d4deccc169.png" alt="Giocatori" title="Giocatori" /></a></li>
                    <li><a href="#guilds"><img src="https://gf3.geo.gfsrv.net/cdn21/f46f0d2068aca9e35f0359d1f1b020.png" alt="Gilde" title="Gilde" /></a></li>
                </ul>

                <div class="tab players selected">
                    <div id="highscore-player">
                                                    <table>
<?php
if(!$offline) {
$top = array();
$top = top10players();
$i = 0;
foreach($top as $player)
{
$i = $i + 1;
$empire=get_player_empire($player['account_id']);
echo '
	<tr>
        <td class="position">',$i,'</td>
        <td class="name"><a href="#">',$player['name'],'</a></td>
        <td class="faction">
			<img src="'.$site_url.'templates/empire'.$empire.'.png" alt="'.emire_name($empire).'" title="'.emire_name($empire).'">
        </td>
    </tr>
';
}
}
?>
</table>
                                            </div>
                    <a href="<?php print $site_url; ?>ranking/players" rel="nofollow">Top 100 &raquo;</a>
                </div>

                <div class="tab guilds">
                    <div id="highscore-guild">
                                                    <table>
<?php
if(!$offline) {
	$top = array();
	$top = top10guilds();
$ib=0;
foreach ($top as $breasla)
{
$ib = $ib + 1;
echo '
    <tr>
        <td class="position">',$ib,'</td>
        <td class="name"><a href="#">',$breasla['name'],'</a></td>
        <td class="faction">
            <b>',$breasla['ladder_point'],'</b>
        </td>
    </tr>
';
} }
?>
</table>
                                            </div>
                    <a href="<?php print $site_url; ?>ranking/guilds" rel="nofollow">Top 100 &raquo;</a>
                </div>

            </aside>
        </div>
		
		</div>
		<script type="text/javascript" src="<?php print $site_url; ?>js/jquery-2.2.4.min.js"></script>
		<script type="text/javascript" src="<?php print $site_url; ?>js/jquery.migrate.js"></script>
		<script type="text/javascript" src="<?php print $site_url; ?>js/featherlight.js"></script>
		<?php include 'include/functions/footer.php'; ?>
		<script src="<?php print $site_url; ?>js/tether.min.js"></script>
		<script src="<?php print $site_url; ?>js/bootstrap.min.js"></script>
		<script src="<?php print $site_url; ?>js/main.js"></script>
	</body>
</html>