<?php

	@ob_start();

	include 'include/functions/header.php';

?>

<!DOCTYPE html>

<html lang="<?php print $language_code; ?>">



<meta http-equiv="content-type" content="text/html;charset=UTF-8" />

<head>

    <meta charset="UTF-8" />

    <meta http-equiv="X-UA-Compatible" content="IE=edge">

	<meta name="viewport" content="initial-scale=0.25">



    <title>Metin2 - Private Server</title>

    <link href="<?php print $site_url; ?>css/bootstrap.minc9e4.css" rel="stylesheet">

	<link rel="stylesheet" href="<?php print $site_url; ?>css/stylec9e4.css" type="text/css" media="screen" charset="utf-8">

	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.3.1/css/all.css" integrity="sha384-mzrmE5qonljUremFsqc01SB46JvROS7bZs3IO2EmfFsd15uHvIt+Y8vEf7N7fWAU" crossorigin="anonymous">

	<link href="<?php print $site_url; ?>css/font-awesome.minf9e3.css?v=1.1" rel="stylesheet">

	<link href="<?php print $site_url; ?>css/fonts.css" rel="stylesheet">

	<link rel="stylesheet" href="<?php print $site_url; ?>css/bootstrap-tablec9e4.css">

	<link rel="stylesheet" href="<?php print $site_url; ?>css/animationc9e4.css">

	<link href="<?php print $site_url; ?>css/flag-icon.minc9e4.css" rel="stylesheet">

	<link rel="shortcut icon" href="<?php print $site_url; ?>images/avatar_discord.png" />

	

	<?php if($page=="admin" && $a_page=="player_edit") { ?>

    <link rel='stylesheet' href='<?php print $site_url; ?>css/bootstrap-select.css'/>

	<?php } ?>

	<script src='https://www.google.com/recaptcha/api.js'></script>

</head>



<body>

	<div class="leaves-2"></div>

	<div class="leaves-3"></div>

	<div class="leaves-4"></div>

	<div class="leaves-5"></div>

    <div class="transparent-overlay" id="page-loader"></div>

	<?php

		if($item_shop!="")

			$shop_url = $item_shop;

		else if(is_dir('shop')) 

			$shop_url = $site_url.'shop'; 

		else print $shop_url = ''; 

	?>

	<div class=" top-panel">

		<div class="top-panel-container">

			<ul class="menu">

				<li class="dropdown">

					<a href="<?php print $site_url; ?>news" id='menu_home'>News</a>

					<div class="dropdown-content">

						<a href="<?php print $site_url; ?>news/1/1">News</a>

						<a href="<?php print $site_url; ?>news/2/1">Events</a>

						<a href="<?php print $site_url; ?>news/3/1" class='last'>Updates</a>

					</div>

				</li>

				<li class="dropdown">

					<a href="<?php print $site_url; ?>ranking/players" id='menu_pvp'>Ranking</a>

					<div class="dropdown-content">

						<a href="<?php print $site_url; ?>ranking/players"><?php print $lang['players']; ?></a>

						<a href="<?php print $site_url; ?>ranking/guilds"><?php print $lang['guilds']; ?></a>

						<a href="<?php print $site_url; ?>ranking/vip" class='last'>VIP</a>

					</div>

				</li>

				<?php if($offline || !$database->is_loggedin()) { ?>

				<li><a href="<?php print $site_url; ?>users/register" id='menu_download'>Register</a></li>

				<?php } else { ?>

				<li><a href="<?php print $site_url; ?>user/administration" id="menu_download">Account</a></li>

				<?php } ?>

				<li><a style="color: #e4745a;" href="<?php print $site_url; ?>download" id='menu_logo'>Download</a></li>

				<li><a href="<?php print $forum; ?>" target="_blank" id='menu_community'>Forum</a></li>

				<li><a data-toggle="modal" data-target="#itemShop" id='menu_support' href="#">ItemShop</a></li>

				<li><a href="<?php print $site_url; ?>user/vote4coins" id='menu_vote4coins'><span class='txt anim-text-flow'>Vote</span></a></li>

			</ul>

		</div>

	</div>

	

    <section id="content">

        <div class="container" style="min-width:1170px;">

            <div id="wrapper">

                <div class="row">

                    <div class="col-xs-9">

                        <div class="content-area">

                            <div class="row">

                                    <div class="slider-topper-wrapper">

                                        <div id="carouselExampleIndicators" class="carousel slide my-4" data-ride="carousel">

										  <ul class="carousel-indicators">

											<li data-target="#carouselExampleIndicators" data-slide-to="0" class="active"></li>

											<li data-target="#carouselExampleIndicators" data-slide-to="1"></li>

											<li data-target="#carouselExampleIndicators" data-slide-to="2"></li>

										  </ul>

										  <div class="carousel-inner" role="listbox">

											<div class="carousel-item active">

												<a href="#">

													<img class="d-block img-fluid" style="width:100%;" src="<?php print $site_url; ?>img/slider/slidea.png" alt="First slide">

												</a>

											</div>

											<div class="carousel-item">

												<a href="#">

													<img class="d-block img-fluid" style="width:100%;" src="<?php print $site_url; ?>img/slider/slideb.png" alt="Second slide">

												</a>

											</div>

											<div class="carousel-item">

												<a href="#">

													<img class="d-block img-fluid" style="width:100%;" src="<?php print $site_url; ?>img/slider/slidec.png" alt="Third slide">

												</a>

											</div>

										  </div>

										  <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button" data-slide="prev">

											<span class="carousel-control-prev-icon" aria-hidden="true"></span>

											<span class="sr-only">Previous</span>

										  </a>

										  <a class="carousel-control-next" href="#carouselExampleIndicators" role="button" data-slide="next">

											<span class="carousel-control-next-icon" aria-hidden="true"></span>

											<span class="sr-only">Next</span>

										  </a>

										</div>

                                    </div>



                                    <style>

                                        #slider-topper .owl-dots {

                                            opacity: 0.4;

                                        }

                                    </style>

                            </div>

                            <div class="news-area">

							<?php include 'pages/'.$page.'.php'; ?>

							</div>

                        </div>

                    </div>

                    <div class="col-xs-3" style="margin-left: 20px;">

                        <div class="sidebar">

							<?php if($offline || !$database->is_loggedin()) { ?>

							<div class="login-area">

							<div class="sidebar-title-login"><?php print $lang['user-panel']; ?></div>

							<div class="separate"></div>

                                <form role="form" method="post" action="<?php print $site_url; ?>users/login" accept-charset="UTF-8">

                                    <div class="form-group">

										<input type="text" name="username" pattern=".{5,64}" maxlength="64" class="form-control" placeholder="<?php print $lang['user-name-or-email']; ?>" autocomplete="off" <?php if($offline) print 'disabled'; else print 'required'; ?>>

                                    </div>

                                    <div class="form-group">

										<input type="password" name="password" pattern=".{5,16}" maxlength="16" class="form-control" placeholder="<?php print $lang['password']; ?>" <?php if($offline) print 'disabled'; else print 'required'; ?>>

                                    </div>

									<div  class="g-recaptcha" data-theme="dark" data-sitekey="<?php print $site_key; ?>" style="transform:scale(0.85);-webkit-transform:scale(0.85);transform-origin:0 0;-webkit-transform-origin:0 0;"></div>

									<p>

										<a href="<?php print $site_url; ?>users/lost"><?php print $lang['forget-password']; ?></a>

										<a class="pull-right" href="<?php print $site_url; ?>users/register"><?php print $lang['register']; ?></a>

									</p>

									<input type="submit" class="btn btn-block btn-login" value="<?php print $lang['login']; ?>">

                                </form>

                            </div>

							<?php } else { ?>

							<div class="login-area user-nav">

									<div class="user-info">

									<img src="<?php print $site_url; ?>images/interfata/default-avatar.jpg" style="margin-top:-15px;margin-right:-20px;" width="70" align="left" class="user-avatar">

									<span>Welcome <a href="<?php print $site_url; ?>user/administration"><?php print getAccountName($_SESSION['id']); ?></a>!</span>

									<span><img src="<?php print $site_url; ?>images/md.png"> <?php print $lang['md']; ?>: <a data-toggle="modal" data-target="#itemShop"><?php print getAccountMD($_SESSION['id']); ?></a></span>

									<span><img src="<?php print $site_url; ?>images/jd.png"> <?php print $lang['jd']; ?>: <a data-toggle="modal" data-target="#itemShop"><?php print getAccountJD($_SESSION['id']); ?></a></span>

								</div>

								<div class="separate"></div>

								<ul>

									<?php if($web_admin) { ?>

									<li><a href="<?php print $site_url; ?>admin" class="user-menu-option"><?php print $lang['administration']; ?><?php if($web_admin>=9 && checkUpdate(officialVersion())) print ' <span class="tag tag-info tag-pill float-xs-right">'.$lang['update-available'].'</span>'; ?></a></li>

									<?php 

										if($web_admin>=$jsondataPrivileges['donate']) {

											$count_donations = count(get_donations());

											if($count_donations)

											{

									?>	

									<li><a href="<?php print $site_url; ?>admin/donatelist" class="user-menu-option"><?php print $lang['donatelist']; ?> <span class="tag tag-info tag-pill float-xs-right"><?php print $count_donations.' '.$lang['new-donations']; ?> </span></a></li>

									<?php

											}

										}

									}

									?>

									<li><a href="<?php print $site_url; ?>user/administration" class="user-menu-option"><?php print $lang['account-data']; ?></a></li>

									<li><a href="<?php print $site_url; ?>user/characters" class="user-menu-option"><?php print $lang['chars-list']; ?></a></li>
									<li><a href="<?php print $site_url; ?>user/redeem" class="user-menu-option"><?php print $lang['redeem-codes']; ?></a></li>

									<?php if($jsondataFunctions['active-referrals']) { ?>

									<li><a href="<?php print $site_url; ?>user/referrals" class="user-menu-option"><?php print $lang['referrals']; ?></a></li>

									<?php } if($item_shop!="") { ?>

									<li><a target='_blank' href="<?php print $item_shop; ?>" class="user-menu-option"><?php print $lang['item-shop']; ?></a></li>

									<?php }

										$vote4coins = file_get_contents('include/db/vote4coins.json');

										$vote4coins = json_decode($vote4coins, true);

										

										if(count($vote4coins))

											print '<li><a href="'.$site_url.'user/vote4coins" class="user-menu-option">Vote4Coins</a></li>';

										

										$donate = file_get_contents('include/db/donate.json');

										$donate = json_decode($donate, true);

										

										if(count($donate))

											print '<li><a href="'.$site_url.'user/donate" class="user-menu-option">'.$lang['donate'].'</a></li>';

									?>

									<li><a href="<?php print $site_url; ?>users/logout" class="user-menu-option"><?php print $lang['logout']; ?></a></li>

									<br>

								</ul>

							</div>

							<?php } ?>

							<div class="online-stats">

							<div class="sidebar-title-stats"><?php print $lang['statistics']; ?></div>

							<div class="separate"></div>

							<?php

								if(!$offline && $statistics)

								foreach($jsondataFunctions as $key => $status)

									if(!in_array($key, array('active-registrations', 'players-debug', 'active-referrals')) && $status)

									{

							?>

                                <p class="number"><?php print number_format(getStatistics($key), 0, '', '.'); ?></p>

                                <p><?php print $lang[$key]; ?></p>

							<?php } ?>

                            </div>

                            <div class="upcoming-events">

                                <div class="hero-overlay" style="margin-right: -30px;">

                                    <img style="height:180px;"src="<?php print $site_url; ?>images/overlay.png" alt="" class="" />

                                </div>

                            </div>



                            <div class="top-lists-wrapper">

                                <div class="top-list metins">

								<div class="sidebar-title-top"><?php print $lang['ranking']; ?></div>

								<div class="separate"></div>

								<br>

                                    <div class="header">

                                        <div class="row">

                                            <div class="col-xs-6 r_title_pvp" id="button_ranking_left">

                                                <span class="text-left"><a style="color:#f6fba7;"><?php print $lang['players']; ?></a></span>

                                            </div>

                                            <div class="col-xs-6 r_title_guilds" id="button_ranking_right">

                                                <span class="text-right"><a style="color:#f6fba7;"><?php print $lang['guilds']; ?></a></span>

                                            </div>

                                            <div class="top-lists-icon">

                                                <img height="64px" src="<?php print $site_url; ?>images/avatar_discord.png" class="" />

                                            </div>

                                        </div>

                                    </div>

									<div id="section_ranking">

									

									<div class="tab-pane active" id="players">

										<div id="player_rank_table" style="">

											<?php

												if(!$offline) {

												$top = array();

												$top = top10players();

												$i = 1;

												foreach($top as $player)

												{

											?>

											<div class="forum pos_<?php print $i; ?>">

												<center><div class="forum-ava"><img src="<?php print $site_url.'images/chrs/'.$player['job']; ?>.jpg" alt=""></div></center>

												<div class="forum-info">

													<a class="forum-title"><?php print $player['name']; ?></a><br>

													<div class="ranking_points_title"><?php print $lang['level']; ?></div>

													<div class="ranking_points_value"><?php print $player['level']; ?></div>

												</div>

											</div>

											<?php $i++; }

												}

											?>

										</div>

										<a href="<?php print $site_url; ?>ranking/players"><div class='view_more'>

											<span class="txt anim-text-flow">TOP 100 &raquo;</span>

										</div></a>

									</div>								

									<div class="tab-pane" id="guilds" style="display:none;">



									<div id="player_rank_table">

										<?php

										if(!$offline) {

											$top = array();

											$top = top10guilds();

											

											$i=1;

											foreach($top as $guild)

											{

										?>

										<div class="forum pos_<?php print $i; ?>">

											<center><div class="forum-ava"><img src="<?php print $site_url.'images/rank/'.$i; ?>.jpg" alt=""></div></center>

											<div class="forum-info">

												<a class="forum-title"><?php print $guild['name']; ?></a><br>

												<div class="ranking_points_title"><?php print $lang['points']; ?></div>

												<div class="ranking_points_value"><?php print number_format($guild['ladder_point'], 0, '', '.'); ?></div>

											</div>

										</div>

										<?php $i++; }

										}

										?>

									</div>

										<a href="<?php print $site_url; ?>ranking/guilds">

											<div class='view_more'>

												<span class="txt anim-text-flow">TOP 100 &raquo;</span>

											</div>

										</a>

									</div>

									

									

									</div>

									

                                </div>

									

                            </div>

							

							<a style="cursor: pointer;color: #f6fba7;/*! font-weight: bold; */font-size: 19px;" data-toggle="modal" data-target="#itemShop">

								<div class="block hero-block">

										<div class="h-read-more-b">

											<i class="fas fa-angle-double-right"></i> ITEMSHOP

										</div>

								</div>

							</a>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </section>

		

    <div id="mini-icons">

		<div class="languagewrapper">

			<a class="current-language flag-icon flag-icon-<?php print $language_code; ?>" type="button" btattached="true"></a>

			<div class="languages">

				<?php

					foreach($json_languages['languages'] as $key => $value)

						if($key != $language_code)

							print '<a href="'.$site_url.'?lang='.$key.'" class="flag-icon flag-icon-'.$key.'"></a>';

				?>

			</div>

		</div>

		<div class="youtube"><a target="_blank" href="<?php print $social_links['youtube']; ?>"><i class="fa fa-youtube"></i></a></div>

		<div class="facebook"><a target="_blank" href="<?php print $social_links['facebook']; ?>"><i class="fa fa-facebook"></i></a></div>

		<div class="instagram"><a target="_blank" href="<?php print $social_links['instagram']; ?>"><i class="fa fa-instagram"></i></a></div>

		<div class="twitch"><a target="_blank" href="<?php print $social_links['twitch']; ?>"><i class="fa fa-twitch"></i></a></div>

		<div class="discord"><a target="_blank" href="<?php print $social_links['discord']; ?>"><i class="fab fa-discord"></i></a></div>

	</div>

	<div id='footer'>

			<div class="toTop-fon">

				<div class="toTop" id="toTop"></div>

			</div>

			<div id='copyright'><a href="<?php print $site_url; ?>"><img src="<?php print $site_url; ?>img/logo.png" class="footer_logo"></a>



				<span class="txt anim-text-flow">Become the bone of your sword and strike the enemies and make your way to the top !</span>



				<div id="separator2"></div>

				<div class="credits">

					<ul style="cursor:pointer;list-style-type: none;float: left;">							

						<li><h5 style="color:#ff3214;">Credits</h5></li>

						<li><i class="fas fa-code"></i> Scripts by <a style="font-size: 12px;color: #888;line-height: 1.7;" href="https://just4metin.ro/member/Ionu%C5%A3/">Ionuț</a></li>

						<li><i class="fas fa-pencil-ruler"></i> Design by <a style="font-size: 12px;color: #888;line-height: 1.7;" href="#">Hust#8111</a></li>

						<li><i class="fas fa-user-edit"></i> Adapted by <a style="font-size: 12px;color: #888;line-height: 1.7;" href="https://just4metin.ro/member/Kayaba/">Kayaba</a></li>

					</ul>			

				</div>

				<div class="footerMenu">

					<ul class="footerColumn">

						<li><h5><?php print $lang['news']; ?></h5></li>

						<li><a href="<?php print $site_url; ?>news/1/1">News</a></li>

						<li><a href="<?php print $site_url; ?>news/2/1">Events</a></li>

						<li><a href="<?php print $site_url; ?>news/3/1" class='last'>Updates</a></li>

					</ul>

					<ul class="footerColumn">

						<li><h5><?php print $lang['ranking']; ?></h5></li>

						<li><a href="<?php print $site_url; ?>ranking/players"><?php print $lang['players']; ?></a></li>

						<li><a href="<?php print $site_url; ?>ranking/guilds" class='last'><?php print $lang['guilds']; ?></a></li>

					</ul>

					<ul class="footerColumn">



						<?php if($offline || !$database->is_loggedin()) { ?>

						<li><h5><?php print $lang['register']; ?></h5></li>

						<li><a href="<?php print $site_url; ?>users/register" id='menu_download'><?php print $lang['register']; ?></a></li>

						<?php } else { ?>

						<li><h5><?php print $lang['account-data']; ?></h5></li>

						<li><a href="<?php print $site_url; ?>user/administration" id='menu_download'><?php print $lang['account-data']; ?></a></li>

						<?php } ?>

					</ul>

					<ul class="footerColumn">

						<li><h5>Forum</h5></li>

						<li><a href="<?php print $forum; ?>" target="_blank" id='menu_community'>Community</a></li>

					</ul>

					<ul class="footerColumn">

						<li><h5>ItemShop</h5></li>

						<li><a data-toggle="modal" data-target="#itemShop" id='menu_support' href="#"><?php print $lang['item-shop']; ?></a></li>

						<li><a href="<?php print $site_url; ?>user/donate" class='last'><?php print $lang['donate']; ?></a></li>

					</ul>

					<ul class="footerColumn">
						<li><h5>PARTENERI</h5></li>

					<a href="https://www.ovinetwork.ro/hosting-metin2"><img src="afiliere-ovi.png"></a>
					</ul>

				</div>

			</div>

	</div>

		

			<div class="modal fade" id="itemShop" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">

				<div class="modal-dialog modal-dialog-centered" role="document" style="max-width: 1030px!important;width: 1030px;">

					<div class="modal-content">

						<div class="modal-header">

							<h5 id="page_title" class="modal-title"><?php print $lang['item-shop']; ?></h5>

							<button type="button" class="close" data-dismiss="modal" aria-label="Close">

								<span aria-hidden="true">&times;</span>

							</button>

						</div>

						<div class="modal-body">

							<iframe id="fancybox-frame" frameborder="0" hspace="0" scrolling="yes" src="<?php print $shop_url; ?>" style="width: 1000px; height: 564px;"></iframe>

						</div>

					</div>

				</div>

			</div>

	

	<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>

	<script type="text/javascript" src="<?php print $site_url; ?>js/main.js"></script>

	<script type="text/javascript" src="<?php print $site_url; ?>js/application.js"></script>

	<?php include 'include/functions/footer.php'; ?>

	<script src="<?php print $site_url; ?>js/tether.min.js"></script>

	<script src="<?php print $site_url; ?>js/bootstrap.min.js"></script>



	<script>

		$('.txt').html(function(i, html) {

			var chars = $.trim(html).split("");

			return '<span>' + chars.join('</span><span>') + '</span>';

		});



		$(".r_title_pvp a").click(function() {

			$("#guilds").hide();

			$("#players").tab('show');

			$("#players").show();

		});



		$(".r_title_guilds a").click(function() {

			$("#players").hide();

			$("#guilds").tab('show');

			$("#guilds").show();

		});

	</script>

	<script>

	$(function() {

		$(window).scroll(function() {

			if($(this).scrollTop() != 0) {

				$('#toTop').fadeIn();

					} else {

					$('#toTop').fadeOut();

					}

					});

				$('#toTop').click(function() {

				$('body,html').animate({scrollTop:0},800);

			});

		});

	</script>

	

	<script src="<?php print $site_url; ?>js/jquery.min.js"></script>

	<script src="<?php print $site_url; ?>js/bootstrap.bundle.min.js"></script>

</body>





</html>